package com.biz.crm.tpm.business.agency.operation.local.service.internal;

import com.biz.crm.tpm.business.agency.operation.local.entity.AgencyOperationGoal;
import com.biz.crm.tpm.business.agency.operation.local.repository.AgencyOperationGoalRepository;
import com.biz.crm.tpm.business.agency.operation.sdk.dto.AgencyOperationGoalDto;
import com.biz.crm.tpm.business.agency.operation.sdk.service.AgencyOperationGoalService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 代运营目标表实现类
 *
 * @author: yaoyongming
 * @date: 2023/8/19 16:29
 */
@Slf4j
@Service("agencyOperationGoalService")
public class AgencyOperationGoalServiceImpl implements AgencyOperationGoalService {

    @Autowired(required = false)
    AgencyOperationGoalRepository agencyOperationGoalRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 导入保存
     *
     * @param dtoList
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void importSave(List<AgencyOperationGoalDto> dtoList) {
        List<String> uniqueKeys = dtoList.stream().map(e -> e.getUniqueKey()).collect(Collectors.toList());
        List<AgencyOperationGoal> byUniqueKey = agencyOperationGoalRepository.findByUniqueKey(uniqueKeys);
        Validate.isTrue(CollectionUtils.isEmpty(byUniqueKey), "系统中存在重复数据，请检查");
        Collection<AgencyOperationGoal> entities = nebulaToolkitService.copyCollectionByWhiteList(dtoList, AgencyOperationGoalDto.class, AgencyOperationGoal.class, LinkedHashSet.class, ArrayList.class);
        agencyOperationGoalRepository.saveBatch(entities);
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        agencyOperationGoalRepository.removeByIds(idList);
    }
}
