/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.agency.operation.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.agency.operation.local.entity.AgencyOperationFee;
import com.biz.crm.tpm.business.agency.operation.local.entity.AgencyOperationGoal;
import com.biz.crm.tpm.business.agency.operation.local.entity.AgencyOperationServiceWeight;
import com.biz.crm.tpm.business.agency.operation.local.repository.AgencyOperationFeeRepository;
import com.biz.crm.tpm.business.agency.operation.local.repository.AgencyOperationGoalRepository;
import com.biz.crm.tpm.business.agency.operation.local.repository.AgencyOperationServiceWeightRepository;
import com.biz.crm.tpm.business.agency.operation.sdk.dto.AgencyOperationFeeDto;
import com.biz.crm.tpm.business.agency.operation.sdk.enums.AgencyOperationEnum;
import com.biz.crm.tpm.business.agency.operation.sdk.service.AgencyOperationFeeService;
import com.biz.crm.tpm.business.agency.operation.sdk.vo.AgencyOperationFeeTableVo;
import com.biz.crm.tpm.business.agency.operation.sdk.vo.AgencyOperationFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="agencyOperationFeeService")
public class AgencyOperationFeeServiceImpl
implements AgencyOperationFeeService {
    private static final Logger log = LoggerFactory.getLogger(AgencyOperationFeeServiceImpl.class);
    @Autowired(required=false)
    AgencyOperationGoalRepository agencyOperationGoalRepository;
    @Autowired(required=false)
    AgencyOperationServiceWeightRepository agencyOperationServiceWeightRepository;
    @Autowired(required=false)
    AgencyOperationFeeRepository agencyOperationFeeRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional(rollbackFor={Exception.class})
    public void create(AgencyOperationFeeDto dto) {
        this.validate(dto);
        this.validateUnique(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List<AgencyOperationFeeTableVo> tableVoList = this.calculationFee(dto);
        if (!CollectionUtils.isEmpty(tableVoList)) {
            dto.setTotal(tableVoList.get(0).getTotal());
        }
        AgencyOperationFee entity = (AgencyOperationFee)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AgencyOperationFee.class, HashSet.class, ArrayList.class, new String[0]));
        this.agencyOperationFeeRepository.save((Object)entity);
    }

    public AgencyOperationFeeVo findById(String id) {
        AgencyOperationFee entity = (AgencyOperationFee)((Object)this.agencyOperationFeeRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e", (Object[])new Object[0]);
        return (AgencyOperationFeeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AgencyOperationFeeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(AgencyOperationFeeDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validate(dto);
        this.validateUnique(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<AgencyOperationFeeTableVo> tableVoList = this.calculationFee(dto);
        if (!CollectionUtils.isEmpty(tableVoList)) {
            dto.setTotal(tableVoList.get(0).getTotal());
        }
        AgencyOperationFee entity = (AgencyOperationFee)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AgencyOperationFee.class, HashSet.class, ArrayList.class, new String[0]));
        this.agencyOperationFeeRepository.saveOrUpdate((Object)entity);
    }

    public void validate(AgencyOperationFeeDto dto) {
        Validate.notBlank((CharSequence)dto.getPlatformCode(), (String)"\u5e73\u53f0\uff0c\u5fc5\u586b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\uff0c\u5fc5\u586b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getChannelCode(), (String)"\u6e20\u9053\uff0c\u5fc5\u586b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSalesInstitutionCode(), (String)"\u9500\u552e\u673a\u6784\uff0c\u5fc5\u586b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u5ba2\u6237\uff0c\u5fc5\u586b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerErpCode(), (String)"\u5ba2\u6237ERP\uff0c\u5fc5\u586b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getSupplierCode(), (String)"\u4f9b\u5e94\u5546\uff0c\u5fc5\u586b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getYearMonthLy(), (String)"\u5e74\u6708\uff0c\u5fc5\u586b\uff01", (Object[])new Object[0]);
    }

    public void validateUnique(AgencyOperationFeeDto dto) {
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getPlatformCode());
        sb.append(dto.getBusinessFormatCode());
        sb.append(dto.getChannelCode());
        sb.append(dto.getSalesInstitutionErpCode());
        sb.append(dto.getCustomerErpCode());
        sb.append(dto.getSupplierCode());
        sb.append(dto.getYearMonthLy());
        dto.setUniqueKey(sb.toString());
        List<AgencyOperationFee> entities = this.agencyOperationFeeRepository.findByUniqueKey(dto.getUniqueKey(), dto.getId());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(entities), (String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        this.agencyOperationFeeRepository.removeByIds(idList);
    }

    public LinkedHashMap<String, String> showFields(String platformCode) {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        if ("tmall".equals(platformCode)) {
            fields.put(AgencyOperationEnum.BRIEF.getFieldCoding(), AgencyOperationEnum.BRIEF.getFieldName());
            fields.put(AgencyOperationEnum.WORK_ACCURACY.getFieldCoding(), AgencyOperationEnum.WORK_ACCURACY.getFieldName());
            fields.put(AgencyOperationEnum.COMPLETION_TIME_POINT.getFieldCoding(), AgencyOperationEnum.COMPLETION_TIME_POINT.getFieldName());
            fields.put(AgencyOperationEnum.VIP_PROPORTION.getFieldCoding(), AgencyOperationEnum.VIP_PROPORTION.getFieldName());
            fields.put(AgencyOperationEnum.REPURCHASE_RATE.getFieldCoding(), AgencyOperationEnum.REPURCHASE_RATE.getFieldName());
            fields.put(AgencyOperationEnum.NEW_PRODUCT.getFieldCoding(), AgencyOperationEnum.NEW_PRODUCT.getFieldName());
            fields.put(AgencyOperationEnum.NEW_VIP.getFieldCoding(), AgencyOperationEnum.NEW_VIP.getFieldName());
            fields.put(AgencyOperationEnum.STORE_DISCOUNT.getFieldCoding(), AgencyOperationEnum.STORE_DISCOUNT.getFieldName());
            fields.put(AgencyOperationEnum.MARKETING_PLANNING.getFieldCoding(), AgencyOperationEnum.MARKETING_PLANNING.getFieldName());
        } else if ("jingdong2".equals(platformCode)) {
            fields.put(AgencyOperationEnum.BRIEF.getFieldCoding(), AgencyOperationEnum.BRIEF.getFieldName());
            fields.put(AgencyOperationEnum.WORK_ACCURACY.getFieldCoding(), AgencyOperationEnum.WORK_ACCURACY.getFieldName());
            fields.put(AgencyOperationEnum.VIP_PROPORTION.getFieldCoding(), AgencyOperationEnum.VIP_PROPORTION.getFieldName());
            fields.put(AgencyOperationEnum.STORE_DISCOUNT.getFieldCoding(), AgencyOperationEnum.STORE_DISCOUNT.getFieldName());
            fields.put(AgencyOperationEnum.MARKETING_PLANNING.getFieldCoding(), AgencyOperationEnum.MARKETING_PLANNING.getFieldName());
            fields.put(AgencyOperationEnum.MARKET_SHARE.getFieldCoding(), AgencyOperationEnum.MARKET_SHARE.getFieldName());
            fields.put(AgencyOperationEnum.NEW_PRODUCT_ACHIEVE.getFieldCoding(), AgencyOperationEnum.NEW_PRODUCT_ACHIEVE.getFieldName());
            fields.put(AgencyOperationEnum.NET_INCOME_ACHIEVE.getFieldCoding(), AgencyOperationEnum.NET_INCOME_ACHIEVE.getFieldName());
            fields.put(AgencyOperationEnum.INVENTORY_TURNOVER_RATE.getFieldCoding(), AgencyOperationEnum.INVENTORY_TURNOVER_RATE.getFieldName());
        } else if ("pinduoduo".equals(platformCode)) {
            fields.put(AgencyOperationEnum.GMV.getFieldCoding(), AgencyOperationEnum.GMV.getFieldName());
            fields.put(AgencyOperationEnum.PAYMENT_CONVERSION_RATE.getFieldCoding(), AgencyOperationEnum.PAYMENT_CONVERSION_RATE.getFieldName());
            fields.put(AgencyOperationEnum.PROMOTE_ROI.getFieldCoding(), AgencyOperationEnum.PROMOTE_ROI.getFieldName());
            fields.put(AgencyOperationEnum.VIP.getFieldCoding(), AgencyOperationEnum.VIP.getFieldName());
            fields.put(AgencyOperationEnum.DISCOUNT_RATE.getFieldCoding(), AgencyOperationEnum.DISCOUNT_RATE.getFieldName());
            fields.put(AgencyOperationEnum.BRIEF.getFieldCoding(), AgencyOperationEnum.BRIEF.getFieldName());
            fields.put(AgencyOperationEnum.WORK_ACCURACY.getFieldCoding(), AgencyOperationEnum.WORK_ACCURACY.getFieldName());
        }
        return fields;
    }

    public List<AgencyOperationFeeTableVo> calculationFee(AgencyOperationFeeDto dto) {
        ArrayList<AgencyOperationFeeTableVo> list = new ArrayList<AgencyOperationFeeTableVo>();
        if (!("tmall".equals(dto.getPlatformCode()) || "jingdong2".equals(dto.getPlatformCode()) || "pinduoduo".equals(dto.getPlatformCode()))) {
            return list;
        }
        this.validate(dto);
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getBusinessFormatCode());
        sb.append(dto.getChannelCode());
        sb.append(dto.getSalesInstitutionErpCode());
        sb.append(dto.getCustomerErpCode());
        sb.append(dto.getSupplierCode());
        sb.append(dto.getYearMonthLy());
        String uniqueKey = sb.toString();
        List<AgencyOperationServiceWeight> swList = this.agencyOperationServiceWeightRepository.findByUniqueKey(Arrays.asList(uniqueKey));
        Validate.notEmpty(swList, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u670d\u52a1\u8d39&\u6743\u91cd\u8868\u7684\u6570\u636e", (Object[])new Object[0]);
        List<AgencyOperationGoal> gList = this.agencyOperationGoalRepository.findByUniqueKey(Arrays.asList(uniqueKey));
        Validate.notEmpty(gList, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u76ee\u6807\u8868\u7684\u6570\u636e", (Object[])new Object[0]);
        AgencyOperationServiceWeight sw = swList.get(0);
        AgencyOperationGoal g = gList.get(0);
        Map<String, Object> swMap = this.fieldToMap((Object)sw);
        Map<String, Object> gMap = this.fieldToMap((Object)g);
        Map<String, Object> fMap = this.fieldToMap(dto);
        LinkedHashMap<String, String> fields = this.showFields(dto.getPlatformCode());
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String fieldCode = entry.getKey();
            AgencyOperationFeeTableVo tableVo = new AgencyOperationFeeTableVo();
            tableVo.setProjectName(entry.getValue());
            tableVo.setMonthService(sw.getServiceFee());
            tableVo.setWeight(this.objToBD(swMap.get(fieldCode)));
            tableVo.setGoal(this.objToBD(gMap.get(fieldCode)));
            tableVo.setActual(this.objToBD(fMap.get(fieldCode)));
            Validate.isTrue((tableVo.getGoal().compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)("\u3010" + tableVo.getProjectName() + "\u3011\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a0"), (Object[])new Object[0]);
            tableVo.setKpi(tableVo.getActual().divide(tableVo.getGoal(), 2, 4));
            if ("jingdong2".equals(dto.getPlatformCode())) {
                BigDecimal kpi;
                BigDecimal ratio = kpi = tableVo.getKpi();
                if (AgencyOperationEnum.MARKET_SHARE.getFieldCoding().equals(fieldCode) || AgencyOperationEnum.NET_INCOME_ACHIEVE.getFieldCoding().equals(fieldCode)) {
                    ratio = kpi.compareTo(new BigDecimal("0.85")) < 0 ? BigDecimal.ZERO : (kpi.compareTo(new BigDecimal("0.85")) >= 0 && kpi.compareTo(BigDecimal.ONE) <= 0 ? BigDecimal.ONE : (kpi.compareTo(BigDecimal.ONE) > 0 && kpi.compareTo(new BigDecimal("1.05")) <= 0 ? new BigDecimal("1.05") : (kpi.compareTo(new BigDecimal("1.05")) > 0 && kpi.compareTo(new BigDecimal("1.1")) <= 0 ? new BigDecimal("1.1") : (kpi.compareTo(new BigDecimal("1.1")) > 0 && kpi.compareTo(new BigDecimal("1.15")) <= 0 ? new BigDecimal("1.15") : (kpi.compareTo(new BigDecimal("1.15")) > 0 && kpi.compareTo(new BigDecimal("1.2")) <= 0 ? new BigDecimal("1.2") : new BigDecimal("1.25"))))));
                } else if (AgencyOperationEnum.NEW_PRODUCT_ACHIEVE.getFieldCoding().equals(fieldCode)) {
                    if (kpi.compareTo(BigDecimal.ONE) < 0) {
                        ratio = BigDecimal.ZERO;
                    }
                } else if (AgencyOperationEnum.INVENTORY_TURNOVER_RATE.getFieldCoding().equals(fieldCode)) {
                    if (kpi.compareTo(BigDecimal.ONE) < 0) {
                        ratio = BigDecimal.ZERO;
                    } else if (kpi.compareTo(BigDecimal.ONE) < 0 || kpi.compareTo(new BigDecimal("1.2")) >= 0) {
                        ratio = new BigDecimal("1.2");
                    }
                }
                tableVo.setScore(new BigDecimal(100).multiply(tableVo.getWeight()).multiply(ratio));
            } else {
                tableVo.setScore(new BigDecimal(100).multiply(tableVo.getWeight()).multiply(tableVo.getKpi()));
            }
            list.add(tableVo);
        }
        BigDecimal scoreTotal = list.stream().map(e -> e.getScore()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal feeTotal = "jingdong2".equals(dto.getPlatformCode()) && scoreTotal.compareTo(new BigDecimal("120")) > 0 ? Optional.ofNullable(((AgencyOperationFeeTableVo)list.get(0)).getMonthService()).orElse(BigDecimal.ZERO).multiply(new BigDecimal("1.2")) : Optional.ofNullable(((AgencyOperationFeeTableVo)list.get(0)).getMonthService()).orElse(BigDecimal.ZERO).multiply(scoreTotal).divide(new BigDecimal(100), 2, 4);
        BigDecimal finalFeeTotal = feeTotal;
        list.forEach(e -> e.setTotal(finalFeeTotal));
        return list;
    }

    public BigDecimal findForFormulaVariable(AgencyOperationFeeDto dto) {
        return this.agencyOperationFeeRepository.findForFormulaVariable(dto);
    }

    private Map<String, Object> fieldToMap(Object obj) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)obj), Map.class);
        return map;
    }

    private BigDecimal objToBD(Object obj) {
        return obj == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(obj));
    }
}

