/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.agency.operation.local.service.internal;

import com.biz.crm.tpm.business.agency.operation.local.entity.AgencyOperationServiceWeight;
import com.biz.crm.tpm.business.agency.operation.local.repository.AgencyOperationServiceWeightRepository;
import com.biz.crm.tpm.business.agency.operation.sdk.dto.AgencyOperationServiceWeightDto;
import com.biz.crm.tpm.business.agency.operation.sdk.service.AgencyOperationServiceWeightService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="agencyOperationServiceWeightService")
public class AgencyOperationServiceWeightServiceImpl
implements AgencyOperationServiceWeightService {
    private static final Logger log = LoggerFactory.getLogger(AgencyOperationServiceWeightServiceImpl.class);
    @Autowired(required=false)
    AgencyOperationServiceWeightRepository agencyOperationServiceWeightRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional(rollbackFor={Exception.class})
    public void importSave(List<AgencyOperationServiceWeightDto> dtoList) {
        List<String> uniqueKeys = dtoList.stream().map(e -> e.getUniqueKey()).collect(Collectors.toList());
        List<AgencyOperationServiceWeight> byUniqueKey = this.agencyOperationServiceWeightRepository.findByUniqueKey(uniqueKeys);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(byUniqueKey), (String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(dtoList, AgencyOperationServiceWeightDto.class, AgencyOperationServiceWeight.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.agencyOperationServiceWeightRepository.saveBatch(entities);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        this.agencyOperationServiceWeightRepository.removeByIds(idList);
    }
}

