/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.agency.operation.local.service.process;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.tpm.business.agency.operation.sdk.dto.AgencyOperationServiceWeightDto;
import com.biz.crm.tpm.business.agency.operation.sdk.service.AgencyOperationServiceWeightService;
import com.biz.crm.tpm.business.agency.operation.sdk.vo.AgencyOperationServiceWeightImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgencyOperationServiceWeightImportProcess
implements ImportProcess<AgencyOperationServiceWeightImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AgencyOperationServiceWeightImportProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AgencyOperationServiceWeightService agencyOperationServiceWeightService;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    private static final String MDM_BUSINESS_FORMAT = "mdm_business_format";

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, AgencyOperationServiceWeightImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.info("\u5f00\u59cb\u5bfc\u5165......");
        HashMap errorMap = Maps.newHashMap();
        try {
            Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List<AgencyOperationServiceWeightDto> importList = this.validate(errorMap, data);
            if (errorMap.size() == 0) {
                log.info("\u5f00\u59cb\u6570\u636e\u4fdd\u5b58......");
                this.agencyOperationServiceWeightService.importSave(importList);
                log.info("\u7ed3\u675f\u6570\u636e\u4fdd\u5b58......");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String errorMsg = e.getMessage();
            if (StringUtils.isEmpty((CharSequence)e.getMessage())) {
                errorMsg = "\u6570\u636e\u5904\u7406\u5931\u8d25\uff01";
            }
            throw new IllegalArgumentException(errorMsg);
        }
        log.info("\u7ed3\u675f\u5bfc\u5165......");
        return errorMap;
    }

    List<AgencyOperationServiceWeightDto> validate(Map<Integer, String> errorMap, LinkedHashMap<Integer, AgencyOperationServiceWeightImportVo> data) {
        List salesOrgVos;
        List customerVos;
        List channelList;
        HashSet<String> customerCodeSet = new HashSet<String>();
        HashSet<String> channelCodeSet = new HashSet<String>();
        HashSet<String> saleOrgCodeSet = new HashSet<String>();
        HashSet<String> supplierCodeSet = new HashSet<String>();
        HashSet<String> uniqueKeySet = new HashSet<String>();
        log.info("\u5f00\u59cb\u975e\u7a7a\u6821\u9a8c......");
        for (Map.Entry<Integer, AgencyOperationServiceWeightImportVo> entry : data.entrySet()) {
            try {
                AgencyOperationServiceWeightImportVo importsVo = entry.getValue();
                Validate.notBlank((CharSequence)importsVo.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)importsVo.getChannelCode(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)importsVo.getSalesInstitutionCode(), (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)importsVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)importsVo.getSupplierCode(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)importsVo.getYearMonthLy(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                customerCodeSet.add(importsVo.getCustomerCode());
                channelCodeSet.add(importsVo.getChannelCode());
                saleOrgCodeSet.add(importsVo.getSalesInstitutionCode());
                supplierCodeSet.add(importsVo.getSupplierCode());
                StringBuffer sb = new StringBuffer();
                sb.append(importsVo.getBusinessFormatCode());
                sb.append(importsVo.getChannelCode());
                sb.append(importsVo.getSalesInstitutionCode());
                sb.append(importsVo.getCustomerCode());
                sb.append(importsVo.getSupplierCode());
                sb.append(importsVo.getYearMonthLy());
                if (uniqueKeySet.contains(sb.toString())) {
                    throw new IllegalArgumentException("\u5f53\u524d\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e");
                }
                uniqueKeySet.add(sb.toString());
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                errorMap.put(entry.getKey(), null == e2.getMessage() ? "\u6570\u636e\u5904\u7406\u5f02\u5e38" : e2.getMessage());
            }
        }
        log.info("\u7ed3\u675f\u975e\u7a7a\u6821\u9a8c......");
        if (!errorMap.isEmpty()) {
            return new ArrayList<AgencyOperationServiceWeightDto>();
        }
        HashMap<String, List<CustomerVo>> customerMap = new HashMap<String, List<CustomerVo>>();
        HashMap<String, String> channelVoMap = new HashMap<String, String>();
        HashMap<String, List<SalesOrgVo>> salesMap = new HashMap<String, List<SalesOrgVo>>();
        HashMap<String, String> supplierMap = new HashMap<String, String>();
        log.info("\u5f00\u59cb\u83b7\u53d6\u57fa\u7840\u6570\u636e......");
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode(MDM_BUSINESS_FORMAT);
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)formatMap), (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u6570\u636e\u5b57\u5178!", (Object[])new Object[0]);
        List supplierVos = this.supplierVoService.findBySupplierCodes(new ArrayList(supplierCodeSet));
        if (CollectionUtils.isNotEmpty((Collection)supplierVos)) {
            Map<String, String> map = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, SupplierVo::getSupplierName, (a, b) -> a));
            supplierMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(channelList = this.customerChannelVoService.findByCodes(new ArrayList(channelCodeSet))))) {
            Map<String, String> map = channelList.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, CustomerChannelVo::getCustomerChannelName, (a, b) -> a));
            channelVoMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(customerVos = this.customerVoService.findByCustomerMdgCodes(new ArrayList(customerCodeSet))))) {
            Map<String, List<CustomerVo>> map = customerVos.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
            customerMap.putAll(map);
        }
        if (CollectionUtils.isNotEmpty((Collection)(salesOrgVos = this.salesOrgVoService.findByErpCodeList(new ArrayList(saleOrgCodeSet))))) {
            Map<String, List<SalesOrgVo>> map = salesOrgVos.stream().collect(Collectors.groupingBy(SalesOrgVo::getErpCode));
            salesMap.putAll(map);
        }
        log.info("\u7ed3\u675f\u83b7\u53d6\u57fa\u7840\u6570\u636e......");
        log.info("\u5f00\u59cb\u5c01\u88c5\u6570\u636e......");
        ArrayList<AgencyOperationServiceWeightDto> dtoList = new ArrayList<AgencyOperationServiceWeightDto>();
        for (Map.Entry<Integer, AgencyOperationServiceWeightImportVo> entry : data.entrySet()) {
            try {
                AgencyOperationServiceWeightImportVo importsVo = entry.getValue();
                if (!formatMap.containsKey(importsVo.getBusinessFormatCode())) {
                    throw new IllegalArgumentException("\u4e1a\u6001\u672a\u80fd\u8bc6\u522b");
                }
                importsVo.setBusinessFormatCode((String)formatMap.get(importsVo.getBusinessFormatCode()));
                if (!channelVoMap.containsKey(importsVo.getChannelCode())) {
                    throw new IllegalArgumentException("\u6e20\u9053\u672a\u80fd\u8bc6\u522b");
                }
                importsVo.setChannelName((String)channelVoMap.get(importsVo.getChannelCode()));
                if (!supplierMap.containsKey(importsVo.getSupplierCode())) {
                    throw new IllegalArgumentException("\u4f9b\u5e94\u5546\u7f16\u7801\u3010" + importsVo.getSupplierCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                importsVo.setSupplierName((String)supplierMap.get(importsVo.getSupplierCode()));
                List salesOrgVoList = (List)salesMap.get(importsVo.getSalesInstitutionCode());
                Validate.isTrue((CollectionUtils.isNotEmpty((Collection)salesOrgVoList) && salesOrgVoList.size() > 0 ? 1 : 0) != 0, (String)("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u3010" + importsVo.getSalesInstitutionCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                SalesOrgVo salesOrgVo = salesOrgVoList.stream().filter(e -> importsVo.getChannelCode().equals(e.getChannelCode()) && importsVo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                Validate.notNull((Object)salesOrgVo, (String)("\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u3010" + importsVo.getSalesInstitutionCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                importsVo.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                List baseByCustomerCodes = (List)customerMap.get(importsVo.getCustomerCode());
                Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)baseByCustomerCodes), (String)("\u5ba2\u6237\u7f16\u7801\u3010" + importsVo.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                CustomerVo customerVo = baseByCustomerCodes.stream().filter(e -> importsVo.getChannelCode().equals(e.getCustomerChannelCode()) && salesOrgVo.getErpCode().equals(e.getSalesInstitutionErpCode()) && importsVo.getBusinessFormatCode().equals(e.getBusinessFormatCode())).findFirst().orElse(null);
                Validate.notNull((Object)customerVo, (String)("\u5ba2\u6237\u7f16\u7801\u3010" + importsVo.getCustomerCode() + "\u3011\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
                importsVo.setCustomerName(customerVo.getCustomerName());
                StringBuffer sb = new StringBuffer();
                sb.append(importsVo.getBusinessFormatCode());
                sb.append(importsVo.getChannelCode());
                sb.append(importsVo.getSalesInstitutionCode());
                sb.append(importsVo.getCustomerCode());
                sb.append(importsVo.getSupplierCode());
                sb.append(importsVo.getYearMonthLy());
                importsVo.setUniqueKey(sb.toString());
                AgencyOperationServiceWeightDto dto = (AgencyOperationServiceWeightDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importsVo, AgencyOperationServiceWeightDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                dto.setTenantCode(TenantUtils.getTenantCode());
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                dtoList.add(dto);
            }
            catch (Exception e3) {
                log.error(e3.getMessage(), (Throwable)e3);
                errorMap.put(entry.getKey(), null == e3.getMessage() ? "\u6570\u636e\u5904\u7406\u5f02\u5e38" : e3.getMessage());
            }
        }
        log.info("\u7ed3\u675f\u5c01\u88c5\u6570\u636e......");
        return dtoList;
    }

    public Class<AgencyOperationServiceWeightImportVo> findCrmExcelVoClass() {
        return AgencyOperationServiceWeightImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_AGENCY_OPERATION_SERVICE_WEIGHT_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u4ee3\u8fd0\u8425\u670d\u52a1\u8d39\u6743\u91cd\u5bfc\u5165";
    }
}

