package com.biz.crm.tpm.business.agency.operation.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;


/**
 * dto
 *
 * @author yaoyongming
 * @create 2023-08-16 15:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AgencyOperationGoalDto", description = "代运营目标dto")
public class AgencyOperationGoalDto extends TenantFlagOpDto {

    /**
     * 唯一标识
     */
    @ApiModelProperty("唯一标识")
    private String uniqueKey;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty("businessFormatCode")
    private String businessFormatCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    private String supplierCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String supplierName;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月")
    private String yearMonthLy;

    /**
     * 服务费（元）
     */
    @ApiModelProperty("服务费（元）")
    private BigDecimal serviceFee;

    /**
     * GMV
     */
    @ApiModelProperty("GMV")
    private BigDecimal gmv;

    /**
     * 支付转化率
     */
    @ApiModelProperty("支付转化率")
    private BigDecimal paymentConversionRate;

    /**
     * 推广ROI
     */
    @ApiModelProperty("推广ROI")
    private BigDecimal promoteRoi;

    /**
     * 会员招募
     */
    @ApiModelProperty("会员招募")
    private BigDecimal vip;

    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    private BigDecimal discountRate;

    /**
     * 不定期brief平均响应时间：<1小时
     */
    @ApiModelProperty("不定期brief平均响应时间：<1小时")
    private BigDecimal brief;

    /**
     * 工作准确率
     */
    @ApiModelProperty("工作准确率")
    private BigDecimal workAccuracy;

    /**
     * 完成工作时间点
     */
    @ApiModelProperty("完成工作时间点")
    private BigDecimal completionTimePoint;

    /**
     * 会员成交占比（会员销售占比）
     */
    @ApiModelProperty("会员成交占比（会员销售占比）")
    private BigDecimal vipProportion;

    /**
     * 全店60天复购率
     */
    @ApiModelProperty("全店60天复购率")
    private BigDecimal repurchaseRate;

    /**
     * 新品成交占比
     */
    @ApiModelProperty("新品成交占比")
    private BigDecimal newProduct;

    /**
     * 新增会员数
     */
    @ApiModelProperty("新增会员数")
    private BigDecimal newVip;

    /**
     * 店铺折扣力度
     */
    @ApiModelProperty("店铺折扣力度")
    private BigDecimal storeDiscount;

    /**
     * 营销活动策略&规划落地承接度
     */
    @ApiModelProperty("营销活动策略&规划落地承接度")
    private BigDecimal marketingPlanning;

    /**
     * 市场占有率
     */
    @ApiModelProperty("市场占有率")
    private BigDecimal marketShare;

    /**
     * 新品达成率
     */
    @ApiModelProperty("新品达成率")
    private BigDecimal newProductAchieve;

    /**
     * 净收入达成率
     */
    @ApiModelProperty("净收入达成率")
    private BigDecimal netIncomeAchieve;

    /**
     * 库存周转率
     */
    @ApiModelProperty("库存周转率")
    private BigDecimal inventoryTurnoverRate;
}
