package com.biz.crm.tpm.business.agency.operation.sdk.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum AgencyOperationEnum {

    SERVICE_FEE("serviceFee", "服务费"),
    GMV("gmv", "GMV"),
    PAYMENT_CONVERSION_RATE("paymentConversionRate", "支付转化率"),
    PROMOTE_ROI("promoteRoi", "推广ROI"),
    VIP("vip", "会员招募"),
    DISCOUNT_RATE("discountRate", "折扣率"),
    BRIEF("brief", "不定期brief平均响应时间：<1小时"),
    WORK_ACCURACY("workAccuracy", "工作准确率"),
    COMPLETION_TIME_POINT("completionTimePoint", "完成工作时间点"),
    VIP_PROPORTION("vipProportion", "会员成交占比（会员销售占比）"),
    REPURCHASE_RATE("repurchaseRate", "全店60天复购率"),
    NEW_PRODUCT("newProduct", "新品成交占比"),
    NEW_VIP("newVip", "新增会员数"),
    STORE_DISCOUNT("storeDiscount", "店铺折扣力度"),
    MARKETING_PLANNING("marketingPlanning", "营销活动策略&规划落地承接度"),
    MARKET_SHARE("marketShare", "市场占有率"),
    NEW_PRODUCT_ACHIEVE("newProductAchieve", "新品达成率"),
    NET_INCOME_ACHIEVE("netIncomeAchieve", "净收入达成率"),
    INVENTORY_TURNOVER_RATE("inventoryTurnoverRate", "库存周转率"),
    ;

    AgencyOperationEnum(String fieldCoding, String fieldName) {
        this.fieldCoding = fieldCoding;
        this.fieldName = fieldName;
    }

    private String fieldCoding;
    private String fieldName;

    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (AgencyOperationEnum t : AgencyOperationEnum.values()) {
            map.put(t.getFieldCoding(), t.getFieldName());
        }
        return map;
    }
}
