package com.biz.crm.tpm.business.agency.operation.sdk.service;

import com.biz.crm.tpm.business.agency.operation.sdk.dto.AgencyOperationFeeDto;
import com.biz.crm.tpm.business.agency.operation.sdk.vo.AgencyOperationFeeTableVo;
import com.biz.crm.tpm.business.agency.operation.sdk.vo.AgencyOperationFeeVo;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * 代运营费用表服务接口
 */
public interface AgencyOperationFeeService {

    /**
     * 新增
     *
     * @param dto
     */
    void create(AgencyOperationFeeDto dto);

    /**
     * 通过主键查询单条数据
     *
     * @param id
     * @return
     */
    AgencyOperationFeeVo findById(String id);

    /**
     * 修改
     *
     * @param dto
     */
    void update(AgencyOperationFeeDto dto);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 获取实际展示字段
     *
     * @param platformCode
     * @return
     */
    LinkedHashMap<String, String> showFields(String platformCode);

    /**
     * 费用计算
     *
     * @param dto
     * @return
     */
    List<AgencyOperationFeeTableVo> calculationFee(AgencyOperationFeeDto dto);

    /**
     * 变量查询
     *
     * @return
     */
    BigDecimal findForFormulaVariable(AgencyOperationFeeDto dto);
}
