package com.biz.crm.tpm.business.agency.operation.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * vo
 *
 * @author yaoyongming
 * @create 2023-08-23 15:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AgencyOperationTableVo", description = "代运营费用计算vo")
public class AgencyOperationFeeTableVo extends TenantFlagOpVo {

    /**
     * 考核项目名称
     */
    @ApiModelProperty("考核项目名称")
    private String projectName;

    /**
     * 月固定服务费
     */
    @ApiModelProperty("月固定服务费")
    private BigDecimal monthService;

    /**
     * 权重
     */
    @ApiModelProperty("权重")
    private BigDecimal weight;

    /**
     * 目标
     */
    @ApiModelProperty("目标")
    private BigDecimal goal;

    /**
     * 实际
     */
    @ApiModelProperty("实际")
    private BigDecimal actual;

    /**
     * KPI
     */
    @ApiModelProperty("KPI")
    private BigDecimal kpi;

    /**
     * 得分
     */
    @ApiModelProperty("得分")
    private BigDecimal score;

    /**
     * 总费用
     */
    @ApiModelProperty("总费用")
    private BigDecimal total;
}
