package com.biz.crm.tpm.business.agency.operation.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.math.BigDecimal;

/**
 * vo
 *
 * @author yaoyongming
 * @create 2023-08-16 15:20
 */
@Data
@CrmExcelImport
@ApiModel("代运营目标导入VO")
public class AgencyOperationGoalImportVo extends CrmExcelVo {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    /**
     * 渠道编码
     */
    @CrmExcelColumn("渠道编码")
    private String channelCode;

    /**
     * 渠道名称
     */
    @CrmExcelColumn("渠道名称")
    private String channelName;

    /**
     * 销售机构编码
     */
    @CrmExcelColumn("销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @CrmExcelColumn("销售机构名称")
    private String salesInstitutionName;

    /**
     * 客户名称
     */
    @CrmExcelColumn("客户名称")
    private String customerName;

    /**
     * 客户编码
     */
    @CrmExcelColumn("客户编码")
    private String customerCode;

    /**
     * 供应商名称
     */
    @CrmExcelColumn("供应商名称")
    private String supplierName;

    /**
     * 供应商编码
     */
    @CrmExcelColumn("供应商编码")
    private String supplierCode;

    /**
     * 年月
     */
    @CrmExcelColumn(value = "年月")
    private String yearMonthLy;

    /**
     * 服务费（元）
     */
    @CrmExcelColumn("服务费（元）")
    private BigDecimal serviceFee;

    /**
     * GMV
     */
    @CrmExcelColumn("GMV")
    private BigDecimal gmv;

    /**
     * 支付转化率
     */
    @CrmExcelColumn("支付转化率")
    private BigDecimal paymentConversionRate;

    /**
     * 推广ROI
     */
    @CrmExcelColumn("推广ROI")
    private BigDecimal promoteRoi;

    /**
     * 会员招募
     */
    @CrmExcelColumn("会员招募")
    private BigDecimal vip;

    /**
     * 折扣率
     */
    @CrmExcelColumn("折扣率")
    private BigDecimal discountRate;

    /**
     * 不定期brief平均响应时间：<1小时
     */
    @CrmExcelColumn("不定期brief平均响应时间：<1小时")
    private BigDecimal brief;

    /**
     * 工作准确率
     */
    @CrmExcelColumn("工作准确率")
    private BigDecimal workAccuracy;

    /**
     * 完成工作时间点
     */
    @CrmExcelColumn("完成工作时间点")
    private BigDecimal completionTimePoint;

    /**
     * 会员成交占比（会员销售占比）
     */
    @CrmExcelColumn("会员成交占比（会员销售占比）")
    private BigDecimal vipProportion;

    /**
     * 全店60天复购率
     */
    @CrmExcelColumn("全店60天复购率")
    private BigDecimal repurchaseRate;

    /**
     * 新品成交占比
     */
    @CrmExcelColumn("新品成交占比")
    private BigDecimal newProduct;

    /**
     * 新增会员数
     */
    @CrmExcelColumn("新增会员数")
    private BigDecimal newVip;

    /**
     * 店铺折扣力度
     */
    @CrmExcelColumn("店铺折扣力度")
    private BigDecimal storeDiscount;

    /**
     * 营销活动策略&规划落地承接度
     */
    @CrmExcelColumn("营销活动策略&规划落地承接度")
    private BigDecimal marketingPlanning;

    /**
     * 市场占有率
     */
    @CrmExcelColumn("市场占有率")
    private BigDecimal marketShare;

    /**
     * 新品达成率
     */
    @CrmExcelColumn("新品达成率")
    private BigDecimal newProductAchieve;

    /**
     * 净收入达成率
     */
    @CrmExcelColumn("净收入达成率")
    private BigDecimal netIncomeAchieve;

    /**
     * 库存周转率
     */
    @CrmExcelColumn("库存周转率")
    private BigDecimal inventoryTurnoverRate;

    /**
     * 唯一标识
     */
    private String uniqueKey;
}
