package com.biz.crm.tpm.business.approval.collect.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectDto;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * 核销采集信息(ApprovalCollect)表相关的http接口
 *
 * @author hc
 * @since 2022-05-17 12:53:38
 */
@RestController
@RequestMapping("/v1/mn/budget/approvalCollect")
@Slf4j
@Api(tags = "核销采集信息")
public class MnApprovalCollectController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private MnApprovalCollectVoService mnApprovalCollectVoService;

    /**
     * 分页查询所有数据
     *
     * @param pageable        分页对象
     * @param approvalCollect 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<MnApprovalCollectVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "approvalCollect", value = "核销采集信息") MnApprovalCollectDto approvalCollect) {
        try {
            Page<MnApprovalCollectVo> page = this.mnApprovalCollectVoService.findByConditions(pageable, approvalCollect);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询基础数据")
    @GetMapping("findById")
    public Result<MnApprovalCollectVo> findById(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
        try {
            MnApprovalCollectVo approvalCollect = this.mnApprovalCollectVoService.findById(id);
            return Result.ok(approvalCollect);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过编码code查询单条数据
     *
     * @param code 编码
     * @return 单条数据
     */
    @ApiOperation(value = "通过编码code查询基本数据")
    @GetMapping("findByCode")
    public Result<MnApprovalCollectVo> findByCode(@RequestParam("code") @ApiParam(name = "code", value = "编码code") String code) {
        try {
            MnApprovalCollectVo approvalCollect = this.mnApprovalCollectVoService.findByCode(code);
            return Result.ok(approvalCollect);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询详情
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询详情数据")
    @GetMapping("findDetailsById")
    public Result<MnApprovalCollectVo> findDetailsById(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
        try {
            MnApprovalCollectVo approvalCollect = this.mnApprovalCollectVoService.findDetailsById(id);
            return Result.ok(approvalCollect);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过编码查询详情
     *
     * @param code 编码
     * @return 单条数据
     */
    @ApiOperation(value = "通过编码code查询详情数据")
    @GetMapping("findDetailsByCode")
    public Result<MnApprovalCollectVo> findDetailsByCode(@RequestParam("code") @ApiParam(name = "code", value = "编码code") String code) {
        try {
            MnApprovalCollectVo approvalCollect = this.mnApprovalCollectVoService.findDetailsByCode(code);
            return Result.ok(approvalCollect);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过编码集查询详情
     *
     * @param codes 编码集
     */
    @ApiOperation(value = "通过编码code查询详情数据")
    @GetMapping("findDetailsByCodes")
    public Result<List<MnApprovalCollectVo>> findDetailsByCodes(@RequestParam("codes") @ApiParam(name = "codes", value = "编码code") Set<String> codes) {
        try {
            List<MnApprovalCollectVo> result = this.mnApprovalCollectVoService.findDetailsByCodes(codes);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param approvalCollect 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<MnApprovalCollectVo> create(@ApiParam(name = "approvalCollect", value = "核销采集信息") @RequestBody MnApprovalCollectDto approvalCollect) {
        try {
            MnApprovalCollectVo result = this.mnApprovalCollectVoService.create(approvalCollect);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param approvalCollect 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<MnApprovalCollectVo> update(@ApiParam(name = "approvalCollect", value = "核销采集信息") @RequestBody MnApprovalCollectDto approvalCollect) {
        try {
            MnApprovalCollectVo result = this.mnApprovalCollectVoService.update(approvalCollect);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "逻辑删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") Set<String> idList) {
        try {
            this.mnApprovalCollectVoService.delete(idList);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用数据
     *
     * @param idList 主键结合
     * @return 禁用数据
     */
    @ApiOperation(value = "禁用数据")
    @PatchMapping("disable")
    public Result<?> disable(@ApiParam(name = "idList", value = "主键集合") @RequestBody Set<String> idList) {
        try {
            this.mnApprovalCollectVoService.updateEnableStatus(idList, EnableStatusEnum.DISABLE.getCode());
            return Result.ok("禁用成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用数据
     *
     * @param idList 主键结合
     * @return 启用数据
     */
    @ApiOperation(value = "启用数据")
    @PatchMapping("enable")
    public Result<?> enable(@ApiParam(name = "idList", value = "主键集合") @RequestBody Set<String> idList) {
        try {
            this.mnApprovalCollectVoService.updateEnableStatus(idList, EnableStatusEnum.ENABLE.getCode());
            return Result.ok("启用成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("下拉查询")
    @PostMapping("getList")
    public Result<List<MnApprovalCollectVo>> getList(@RequestBody MnApprovalCollectDto approvalCollect){
        try {
            return Result.ok(this.mnApprovalCollectVoService.getList(approvalCollect));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
