package com.biz.crm.tpm.business.approval.collect.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("tpm_mn_approval_collect")
@Table(name = "tpm_mn_approval_collect", indexes = {@Index(name = "tpm_mn_approval_collect_index1", columnList = "tenant_code, code", unique = true)})
@ApiModel(value = "MnApprovalCollect", description = "核销采集信息")
@org.hibernate.annotations.Table(appliesTo = "tpm_mn_approval_collect", comment = "核销采集信息")
public class MnApprovalCollect extends TenantFlagOpEntity {

    @ApiModelProperty("编码")
    @TableField(value = "code", fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
    @Column(name = "code", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '编码'")
    private String code;

    @ApiModelProperty("名称")
    @TableField(value = "name")
    @Column(name = "name", nullable = false, columnDefinition = "varchar(255) COMMENT '名称'")
    private String name;

    /**
     * 参见com.biz.tpm.business.budget.sdk.enums.ApprovalCollectType
     */
    @ApiModelProperty("核销采集类型")
    @TableField(value = "type")
    @Column(name = "type", length = 32, nullable = false, columnDefinition = "varchar(32) COMMENT '核销采集类型'")
    private String type;

    @ApiModelProperty("排序(值越小越靠前)")
    @TableField(value = "sort_index")
    @Column(name = "sort_index", length = 4, nullable = false, columnDefinition = "int(4) COMMENT '排序(值越小越靠前)'")
    private Integer sortIndex;

    @ApiModelProperty("描述")
    @TableField(value = "descr")
    @Column(name = "descr", length = 512, nullable = false, columnDefinition = "varchar(512) COMMENT '描述'")
    private String descr;

    /**
     * 数据字典:mdm_business_format
     */
    @ApiModelProperty(name = "业态编码", notes = "业态编码")
    @Column(name = "business_format_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态编码'")
    private String businessFormatCode;

    /**
     * 数据字典:mdm_business_unit
     */
    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("图片信息")
    @TableField(exist = false)
    @Transient
    private List<MnApprovalCollectImage> images;
}
