package com.biz.crm.tpm.business.approval.collect.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("tpm_mn_approval_collect_image")
@ApiModel(value = "MnApprovalCollectImage", description = "核销采集图片")
@org.hibernate.annotations.Table(appliesTo = "tpm_mn_approval_collect_image", comment = "核销采集图片")
@Table(name = "tpm_mn_approval_collect_image", indexes = {@Index(name = "tpm_mn_approval_collect_image_index1", columnList = "tenant_code, approval_collect_code,id", unique = true)})
public class MnApprovalCollectImage extends FileEntity {

    @ApiModelProperty("核销采集编码")
    @TableField(value = "approval_collect_code")
    @Column(name = "approval_collect_code", nullable = false, columnDefinition = "varchar(255) COMMENT '核销采集编码'")
    private String approvalCollectCode;
}
