package com.biz.crm.tpm.business.approval.collect.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.approval.collect.local.entity.MnApprovalCollectImage;
import com.biz.crm.tpm.business.approval.collect.local.mapper.MnApprovalCollectImageMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;


/**
 * 核销采集信息(ApprovalCollectImage)表数据库访问层
 *
 * @author hc
 * @since 2022-05-17 12:54:02
 */
@Component
public class MnApprovalCollectImageRepository extends ServiceImpl<MnApprovalCollectImageMapper, MnApprovalCollectImage> {

    public void deleteByApprovalCollectCode(String approvalCollectCode) {
        this.lambdaUpdate().eq(MnApprovalCollectImage::getApprovalCollectCode, approvalCollectCode).remove();
    }

    public List<MnApprovalCollectImage> findByApprovalCollectCode(String approvalCollectCode) {
        if (StringUtils.isBlank(approvalCollectCode)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(MnApprovalCollectImage::getTenantCode, TenantUtils.getTenantCode())
                .eq(MnApprovalCollectImage::getApprovalCollectCode, approvalCollectCode)
                .list();
    }

    public List<MnApprovalCollectImage> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(MnApprovalCollectImage::getTenantCode, TenantUtils.getTenantCode())
                .in(MnApprovalCollectImage::getId, ids)
                .list();
    }
}

