package com.biz.crm.tpm.business.approval.collect.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.approval.collect.local.entity.MnApprovalCollect;
import com.biz.crm.tpm.business.approval.collect.local.mapper.MnApprovalCollectMapper;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectDto;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;


/**
 * 核销采集信息(ApprovalCollect)表数据库访问层
 *
 * @author hc
 * @since 2022-05-17 12:54:02
 */
@Component
public class MnApprovalCollectRepository extends ServiceImpl<MnApprovalCollectMapper, MnApprovalCollect> {

  @Resource
  private MnApprovalCollectMapper mnApprovalCollectMapper;

  /**
   * 分页查询数据
   *
   * @param pageable        分页对象
   * @param approvalCollect 实体对象
   */
  public Page<MnApprovalCollectVo> findByConditions(Pageable pageable, MnApprovalCollectDto approvalCollect) {
    if(pageable == null){
      pageable = PageRequest.of(1,50);
    }
    approvalCollect.setTenantCode(TenantUtils.getTenantCode());
    Page<MnApprovalCollectVo> page = new Page<MnApprovalCollectVo>(pageable.getPageNumber(), pageable.getPageSize());
    return mnApprovalCollectMapper.findByConditions(page, approvalCollect);
  }

  /**
   * 根据编码查询信息
   */
  public MnApprovalCollect findByCode(String code){
    return this.lambdaQuery().eq(MnApprovalCollect::getCode,code).eq(MnApprovalCollect::getTenantCode,TenantUtils.getTenantCode()).one();
  }

  /**
   * 根据编码集查询信息
   */
  public List<MnApprovalCollect> findByCodes(Set<String> codes){
    return this.lambdaQuery().in(MnApprovalCollect::getCode,codes).eq(MnApprovalCollect::getTenantCode,TenantUtils.getTenantCode()).list();
  }


  /**
   * 启禁用
   */
  public void updateEnableStatus(Set<String> ids, String enableStatus){
    this.lambdaUpdate().in(MnApprovalCollect::getId,ids).
        set(MnApprovalCollect::getEnableStatus,enableStatus).update();
  }

  /**
   * 逻辑删除
   */
  public void delete(Set<String> ids){
    this.lambdaUpdate().in(MnApprovalCollect::getId,ids)
            .set(MnApprovalCollect::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
            .update();
  }
}

