package com.biz.crm.tpm.business.approval.collect.local.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.approval.collect.local.entity.MnApprovalCollectImage;
import com.biz.crm.tpm.business.approval.collect.local.repository.MnApprovalCollectImageRepository;
import com.biz.crm.tpm.business.approval.collect.sdk.constant.MnApprovalCollectConstant;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectDto;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectImageDto;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectImageVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectImageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.TimeUnit;

@Slf4j
@Service
public class MnApprovalCollectImageVoServiceImpl implements MnApprovalCollectImageVoService {

    @Autowired(required = false)
    private MnApprovalCollectVoService mnApprovalCollectVoService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private MnApprovalCollectImageRepository mnApprovalCollectImageRepository;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    /**
     * 新增
     *
     * @param dto
     * @param images
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<MnApprovalCollectImageVo> create(MnApprovalCollectDto dto, List<MnApprovalCollectImageDto> images) {
        Validate.notNull(dto, "核销采集信息不能为空");
        Validate.notBlank(dto.getCode(), "核销采集编码不能为空");
        Validate.notEmpty(images, "核销采集图片信息不能为空");
        for (MnApprovalCollectImageDto image : images) {
            image.setId(null);
//            String ruleCode = StringUtils.join(MnApprovalCollectConstant.MN_APPROVAL_COLLECT_IMAGE_FORMULA_PREFIX, DateFormatUtils.format(new Date(), "yyyyMMdd"));
            if(StringUtils.isEmpty(image.getFileCode())){
                String code = this.generateCodeService.generateCode(MnApprovalCollectConstant.MN_APPROVAL_COLLECT_IMAGE_FORMULA_PREFIX, 1, 5, 2, TimeUnit.DAYS).get(0);
                image.setFileCode(code);
            }
            image.setApprovalCollectCode(dto.getCode());
        }

        Collection<MnApprovalCollectImage> imageEntities = nebulaToolkitService.copyCollectionByWhiteList(images, MnApprovalCollectImageDto.class, MnApprovalCollectImage.class, HashSet.class, ArrayList.class);
        mnApprovalCollectImageRepository.saveBatch(imageEntities);
        Collection<MnApprovalCollectImageVo> result = nebulaToolkitService.copyCollectionByWhiteList(imageEntities, MnApprovalCollectImage.class, MnApprovalCollectImageVo.class, HashSet.class, ArrayList.class);
        return Lists.newArrayList(result);
    }


    /**
     * 根据编码查询
     *
     * @param code
     * @return
     */
    @Override
    public List<MnApprovalCollectImageVo> findByApprovalCollectCode(String code) {
        if (StringUtils.isBlank(code)) {
            return Lists.newArrayList();
        }
        List<MnApprovalCollectImage> images = mnApprovalCollectImageRepository.findByApprovalCollectCode(code);
        if (CollectionUtils.isEmpty(images)) {
            return Lists.newArrayList();
        }
        Collection<MnApprovalCollectImageVo> collection = nebulaToolkitService.copyCollectionByWhiteList(images, MnApprovalCollectImage.class, MnApprovalCollectImageVo.class, HashSet.class, ArrayList.class);
        return Lists.newArrayList(collection);
    }

    /**
     * 物理删除
     *
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(Set<String> ids) {
        Validate.notEmpty(ids, "主键id不能为空");
        mnApprovalCollectImageRepository.removeByIds(ids);
    }

    /**
     * 根据id集合查询
     *
     * @param ids
     */
    @Override
    public List<MnApprovalCollectImageVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<>(0);
        }
        List<MnApprovalCollectImage> images = this.mnApprovalCollectImageRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(images)) {
            return Lists.newArrayList();
        }
        Collection<MnApprovalCollectImageVo> collection = nebulaToolkitService.copyCollectionByWhiteList(images, MnApprovalCollectImage.class, MnApprovalCollectImageVo.class, HashSet.class, ArrayList.class);
        return Lists.newArrayList(collection);
    }
}
