package com.biz.crm.tpm.business.approval.collect.local.service.internal;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectDto;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author duyiran
 * @date 2022-10-29 15:04
 */
@Slf4j
@Component
public class MnApprovalCollectImportsProcess implements ImportProcess<MnApprovalCollectImportsVo> {

    @Autowired(required = false)
    private MnApprovalCollectVoService mnApprovalCollectVoService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;


    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, MnApprovalCollectImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, "导入数据不能为空！");

        List<MnApprovalCollectDto> importList = this.validate(data);

        mnApprovalCollectVoService.importSave(importList);
        return null;
    }

    /**
     * 校验数据
     *
     * @param data data
     * @author duyiran
     * @date 2022-10-29 15:04
     **/
    private List<MnApprovalCollectDto> validate(LinkedHashMap<Integer, MnApprovalCollectImportsVo> data) {
        List<MnApprovalCollectImportsVo> mnApprovalCollectImportsVos = new ArrayList<>(data.values());

        // TODO:校验
        mnApprovalCollectImportsVos.forEach(importsVo -> {

        });
        Collection<MnApprovalCollectDto> mnApprovalCollectDtos = nebulaToolkitService.copyCollectionByWhiteList(mnApprovalCollectImportsVos, MnApprovalCollectImportsVo.class, MnApprovalCollectDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(mnApprovalCollectDtos);
    }

    @Override
    public Class<MnApprovalCollectImportsVo> findCrmExcelVoClass() {
        return MnApprovalCollectImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_MN_APPROVAL_COLLECT_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "TPM核销&采集示例导入";
    }
}
