/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.approval.collect.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectDto;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/mn/budget/approvalCollect"})
@Api(tags={"\u6838\u9500\u91c7\u96c6\u4fe1\u606f"})
public class MnApprovalCollectController {
    private static final Logger log = LoggerFactory.getLogger(MnApprovalCollectController.class);
    @Autowired(required=false)
    private MnApprovalCollectVoService mnApprovalCollectVoService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<MnApprovalCollectVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="approvalCollect", value="\u6838\u9500\u91c7\u96c6\u4fe1\u606f") MnApprovalCollectDto approvalCollect) {
        try {
            Page page = this.mnApprovalCollectVoService.findByConditions(pageable, approvalCollect);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u57fa\u7840\u6570\u636e")
    @GetMapping(value={"findById"})
    public Result<MnApprovalCollectVo> findById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            MnApprovalCollectVo approvalCollect = this.mnApprovalCollectVoService.findById(id);
            return Result.ok((Object)approvalCollect);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801code\u67e5\u8be2\u57fa\u672c\u6570\u636e")
    @GetMapping(value={"findByCode"})
    public Result<MnApprovalCollectVo> findByCode(@RequestParam(value="code") @ApiParam(name="code", value="\u7f16\u7801code") String code) {
        try {
            MnApprovalCollectVo approvalCollect = this.mnApprovalCollectVoService.findByCode(code);
            return Result.ok((Object)approvalCollect);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u8be6\u60c5\u6570\u636e")
    @GetMapping(value={"findDetailsById"})
    public Result<MnApprovalCollectVo> findDetailsById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            MnApprovalCollectVo approvalCollect = this.mnApprovalCollectVoService.findDetailsById(id);
            return Result.ok((Object)approvalCollect);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801code\u67e5\u8be2\u8be6\u60c5\u6570\u636e")
    @GetMapping(value={"findDetailsByCode"})
    public Result<MnApprovalCollectVo> findDetailsByCode(@RequestParam(value="code") @ApiParam(name="code", value="\u7f16\u7801code") String code) {
        try {
            MnApprovalCollectVo approvalCollect = this.mnApprovalCollectVoService.findDetailsByCode(code);
            return Result.ok((Object)approvalCollect);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801code\u67e5\u8be2\u8be6\u60c5\u6570\u636e")
    @GetMapping(value={"findDetailsByCodes"})
    public Result<List<MnApprovalCollectVo>> findDetailsByCodes(@RequestParam(value="codes") @ApiParam(name="codes", value="\u7f16\u7801code") Set<String> codes) {
        try {
            List result = this.mnApprovalCollectVoService.findDetailsByCodes(codes);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<MnApprovalCollectVo> create(@ApiParam(name="approvalCollect", value="\u6838\u9500\u91c7\u96c6\u4fe1\u606f") @RequestBody MnApprovalCollectDto approvalCollect) {
        try {
            MnApprovalCollectVo result = this.mnApprovalCollectVoService.create(approvalCollect);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<MnApprovalCollectVo> update(@ApiParam(name="approvalCollect", value="\u6838\u9500\u91c7\u96c6\u4fe1\u606f") @RequestBody MnApprovalCollectDto approvalCollect) {
        try {
            MnApprovalCollectVo result = this.mnApprovalCollectVoService.update(approvalCollect);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") Set<String> idList) {
        try {
            this.mnApprovalCollectVoService.delete(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528\u6570\u636e")
    @PatchMapping(value={"disable"})
    public Result<?> disable(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody Set<String> idList) {
        try {
            this.mnApprovalCollectVoService.updateEnableStatus(idList, EnableStatusEnum.DISABLE.getCode());
            return Result.ok((String)"\u7981\u7528\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528\u6570\u636e")
    @PatchMapping(value={"enable"})
    public Result<?> enable(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody Set<String> idList) {
        try {
            this.mnApprovalCollectVoService.updateEnableStatus(idList, EnableStatusEnum.ENABLE.getCode());
            return Result.ok((String)"\u542f\u7528\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u62c9\u67e5\u8be2")
    @PostMapping(value={"getList"})
    public Result<List<MnApprovalCollectVo>> getList(@RequestBody MnApprovalCollectDto approvalCollect) {
        try {
            return Result.ok((Object)this.mnApprovalCollectVoService.getList(approvalCollect));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

