/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.approval.collect.local.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.approval.collect.local.entity.MnApprovalCollectImage;
import com.biz.crm.tpm.business.approval.collect.local.repository.MnApprovalCollectImageRepository;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectDto;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectImageDto;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectImageVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectImageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MnApprovalCollectImageVoServiceImpl
implements MnApprovalCollectImageVoService {
    private static final Logger log = LoggerFactory.getLogger(MnApprovalCollectImageVoServiceImpl.class);
    @Autowired(required=false)
    private MnApprovalCollectVoService mnApprovalCollectVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MnApprovalCollectImageRepository mnApprovalCollectImageRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    @Transactional(rollbackFor={Exception.class})
    public List<MnApprovalCollectImageVo> create(MnApprovalCollectDto dto, List<MnApprovalCollectImageDto> images) {
        Validate.notNull((Object)dto, (String)"\u6838\u9500\u91c7\u96c6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCode(), (String)"\u6838\u9500\u91c7\u96c6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(images, (String)"\u6838\u9500\u91c7\u96c6\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (MnApprovalCollectImageDto image : images) {
            image.setId(null);
            if (StringUtils.isEmpty((CharSequence)image.getFileCode())) {
                String code = (String)this.generateCodeService.generateCode("HXCJTP", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
                image.setFileCode(code);
            }
            image.setApprovalCollectCode(dto.getCode());
        }
        Collection imageEntities = this.nebulaToolkitService.copyCollectionByWhiteList(images, MnApprovalCollectImageDto.class, MnApprovalCollectImage.class, HashSet.class, ArrayList.class, new String[0]);
        this.mnApprovalCollectImageRepository.saveBatch(imageEntities);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)imageEntities, MnApprovalCollectImage.class, MnApprovalCollectImageVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)result);
    }

    public List<MnApprovalCollectImageVo> findByApprovalCollectCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Lists.newArrayList();
        }
        List<MnApprovalCollectImage> images = this.mnApprovalCollectImageRepository.findByApprovalCollectCode(code);
        if (CollectionUtils.isEmpty(images)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(images, MnApprovalCollectImage.class, MnApprovalCollectImageVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(Set<String> ids) {
        Validate.notEmpty(ids, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.mnApprovalCollectImageRepository.removeByIds(ids);
    }

    public List<MnApprovalCollectImageVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<MnApprovalCollectImageVo>(0);
        }
        List<MnApprovalCollectImage> images = this.mnApprovalCollectImageRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(images)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(images, MnApprovalCollectImage.class, MnApprovalCollectImageVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }
}

