/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.approval.collect.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.tpm.business.approval.collect.local.entity.MnApprovalCollect;
import com.biz.crm.tpm.business.approval.collect.local.repository.MnApprovalCollectRepository;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectDto;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectImageDto;
import com.biz.crm.tpm.business.approval.collect.sdk.dto.MnApprovalCollectLogEventDto;
import com.biz.crm.tpm.business.approval.collect.sdk.enums.MnApprovalCollectType;
import com.biz.crm.tpm.business.approval.collect.sdk.event.MnApprovalCollectEventListener;
import com.biz.crm.tpm.business.approval.collect.sdk.event.log.MnApprovalCollectLogEventListener;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectImageVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectImageVo;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="mnApprovalCollectService")
public class MnApprovalCollectServiceImpl
implements MnApprovalCollectVoService {
    private static final Logger log = LoggerFactory.getLogger(MnApprovalCollectServiceImpl.class);
    @Autowired(required=false)
    private MnApprovalCollectRepository mnApprovalCollectRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private MnApprovalCollectImageVoService approvalCollectImageService;
    @Autowired(required=false)
    private List<MnApprovalCollectEventListener> mnApprovalCollectEventListeners;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;

    public Page<MnApprovalCollectVo> findByConditions(Pageable pageable, MnApprovalCollectDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        if (dto == null) {
            dto = new MnApprovalCollectDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.mnApprovalCollectRepository.findByConditions(pageable, dto);
    }

    public MnApprovalCollectVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MnApprovalCollect approvalCollect = (MnApprovalCollect)((Object)this.mnApprovalCollectRepository.getById((Serializable)((Object)id)));
        if (approvalCollect == null) {
            return null;
        }
        MnApprovalCollectVo result = (MnApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)approvalCollect, MnApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
        List imageVos = this.approvalCollectImageService.findByApprovalCollectCode(approvalCollect.getCode());
        result.setImages(imageVos);
        return result;
    }

    public List<MnApprovalCollectVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List approvalCollects = this.mnApprovalCollectRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)approvalCollects)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)approvalCollects, MnApprovalCollect.class, MnApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public MnApprovalCollectVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MnApprovalCollect approvalCollect = (MnApprovalCollect)((Object)this.mnApprovalCollectRepository.getById((Serializable)((Object)id)));
        if (approvalCollect == null) {
            return null;
        }
        MnApprovalCollectVo result = (MnApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)approvalCollect, MnApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
        List imageVos = this.approvalCollectImageService.findByApprovalCollectCode(approvalCollect.getCode());
        result.setImages(imageVos);
        return result;
    }

    public MnApprovalCollectVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        MnApprovalCollect approvalCollect = this.mnApprovalCollectRepository.findByCode(code);
        if (approvalCollect == null) {
            return null;
        }
        return (MnApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)approvalCollect, MnApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public MnApprovalCollectVo findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        MnApprovalCollect approvalCollect = this.mnApprovalCollectRepository.findByCode(code);
        if (approvalCollect == null) {
            return null;
        }
        MnApprovalCollectVo result = (MnApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)approvalCollect, MnApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
        List imageVos = this.approvalCollectImageService.findByApprovalCollectCode(approvalCollect.getCode());
        result.setImages(imageVos);
        return result;
    }

    public List<MnApprovalCollectVo> findDetailsByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<MnApprovalCollect> approvalCollects = this.mnApprovalCollectRepository.findByCodes(codes);
        if (CollectionUtils.isEmpty(approvalCollects)) {
            return Lists.newArrayList();
        }
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList(approvalCollects, MnApprovalCollect.class, MnApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (MnApprovalCollectVo approvalCollect : result) {
            List imageVos = this.approvalCollectImageService.findByApprovalCollectCode(approvalCollect.getCode());
            if (CollectionUtils.isEmpty((Collection)imageVos)) continue;
            approvalCollect.setImages(imageVos);
        }
        return Lists.newArrayList((Iterable)result);
    }

    @Transactional(rollbackFor={Exception.class})
    public MnApprovalCollectVo create(MnApprovalCollectDto dto) {
        this.createValidate(dto);
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        String code = (String)this.generateCodeService.generateCode("HXCJ", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        dto.setCode(code);
        MnApprovalCollect entity = (MnApprovalCollect)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, MnApprovalCollect.class, HashSet.class, ArrayList.class, new String[]{"images"}));
        this.mnApprovalCollectRepository.save((Object)entity);
        if (!CollectionUtils.isEmpty((Collection)dto.getImages())) {
            this.approvalCollectImageService.create(dto, dto.getImages());
        }
        MnApprovalCollectLogEventDto logEventDto = new MnApprovalCollectLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = MnApprovalCollectLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MnApprovalCollectLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (MnApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, MnApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[]{"images"});
    }

    @Transactional(rollbackFor={Exception.class})
    public MnApprovalCollectVo update(MnApprovalCollectDto approvalCollect) {
        List needAdds;
        this.updateValidate(approvalCollect);
        MnApprovalCollect dbApprovalCollect = (MnApprovalCollect)((Object)this.mnApprovalCollectRepository.getById((Serializable)((Object)approvalCollect.getId())));
        MnApprovalCollectDto oldDto = (MnApprovalCollectDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbApprovalCollect, MnApprovalCollectDto.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)dbApprovalCollect), (String)"\u6839\u636e\u6307\u5b9a\u7684id\u952e\u503c\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        MnApprovalCollectVo oldApprovalCollect = (MnApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbApprovalCollect, MnApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
        dbApprovalCollect.setDescr(approvalCollect.getDescr());
        dbApprovalCollect.setName(approvalCollect.getName());
        dbApprovalCollect.setSortIndex(approvalCollect.getSortIndex());
        dbApprovalCollect.setType(approvalCollect.getType());
        this.mnApprovalCollectRepository.saveOrUpdate((Object)dbApprovalCollect);
        List imageVos = this.approvalCollectImageService.findByApprovalCollectCode(dbApprovalCollect.getCode());
        Set<Object> currentIds = Sets.newHashSet();
        Set<Object> dbIds = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)approvalCollect.getImages())) {
            currentIds = approvalCollect.getImages().stream().map(UuidDto::getId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty((Collection)imageVos)) {
            dbIds = imageVos.stream().map(UuidVo::getId).collect(Collectors.toSet());
        }
        Sets.SetView needDeletes = Sets.difference((Set)dbIds, (Set)currentIds);
        List oldImages = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)needDeletes)) {
            oldImages = this.approvalCollectImageService.findByIds((List)Lists.newArrayList((Iterable)needDeletes));
            this.approvalCollectImageService.deleteByIds((Set)needDeletes);
        }
        if (!CollectionUtils.isEmpty(needAdds = approvalCollect.getImages().stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toList()))) {
            this.approvalCollectImageService.create(approvalCollect, needAdds);
        }
        if (!CollectionUtils.isEmpty(this.mnApprovalCollectEventListeners)) {
            for (MnApprovalCollectEventListener listener : this.mnApprovalCollectEventListeners) {
                MnApprovalCollectVo newApprovalCollect = (MnApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbApprovalCollect, MnApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
                listener.onUpdate(oldApprovalCollect, newApprovalCollect);
            }
        }
        MnApprovalCollectLogEventDto logEventDto = new MnApprovalCollectLogEventDto();
        if (!CollectionUtils.isEmpty(oldImages)) {
            List mnApprovalCollectImageDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(oldImages, MnApprovalCollectImageVo.class, MnApprovalCollectImageDto.class, HashSet.class, ArrayList.class, new String[0]);
            oldDto.setImages(mnApprovalCollectImageDtos);
        }
        logEventDto.setOriginal(oldDto);
        MnApprovalCollectDto newDto = (MnApprovalCollectDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbApprovalCollect, MnApprovalCollectDto.class, HashSet.class, ArrayList.class, new String[0]);
        newDto.setImages(needAdds);
        logEventDto.setNewest(newDto);
        SerializableBiConsumer & Serializable onUpdate = MnApprovalCollectLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MnApprovalCollectLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return this.findDetailsByCode(approvalCollect.getCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(Set<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<MnApprovalCollectVo> mnApprovalCollectVos = this.findByIds(idList);
        Validate.notEmpty(mnApprovalCollectVos, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.mnApprovalCollectEventListeners)) {
            for (MnApprovalCollectEventListener listener : this.mnApprovalCollectEventListeners) {
                for (MnApprovalCollectVo mnApprovalCollectVo : mnApprovalCollectVos) {
                    listener.onDeleted(mnApprovalCollectVo);
                }
            }
        }
        this.mnApprovalCollectRepository.delete(idList);
        Collection mnApprovalCollectDtos = this.nebulaToolkitService.copyCollectionByWhiteList(mnApprovalCollectVos, MnApprovalCollectVo.class, MnApprovalCollectDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = MnApprovalCollectLogEventListener::onDelete;
        for (MnApprovalCollectDto mnApprovalCollectDto : mnApprovalCollectDtos) {
            MnApprovalCollectLogEventDto logEventDto = new MnApprovalCollectLogEventDto();
            logEventDto.setOriginal(mnApprovalCollectDto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MnApprovalCollectLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateEnableStatus(Set<String> ids, String enableStatus) {
        Validate.notEmpty(ids, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)enableStatus, (String)"\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<MnApprovalCollectVo> approvalCollects = this.findByIds(ids);
        Validate.notEmpty(approvalCollects, (String)"\u6839\u636e\u6307\u5b9a\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.contains((String)enableStatus), (String)"\u672a\u77e5\u7684\u542f\u7981\u7528\u72b6\u6001", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        this.mnApprovalCollectRepository.updateEnableStatus(approvalCollects.stream().filter(e -> tenantCode.equals(e.getTenantCode())).map(UuidVo::getId).collect(Collectors.toSet()), enableStatus);
        List mnApprovalCollectDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(approvalCollects, MnApprovalCollectVo.class, MnApprovalCollectDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onUpdateEnable = MnApprovalCollectLogEventListener::onUpdate;
        for (MnApprovalCollectDto mnApprovalCollectDto : mnApprovalCollectDtos) {
            MnApprovalCollectLogEventDto logEventDto = new MnApprovalCollectLogEventDto();
            logEventDto.setOriginal(mnApprovalCollectDto);
            MnApprovalCollectDto newDto = new MnApprovalCollectDto();
            newDto.setEnableStatus(enableStatus);
            logEventDto.setNewest(newDto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MnApprovalCollectLogEventListener.class, (SerializableBiConsumer)onUpdateEnable);
        }
    }

    public void importSave(List<MnApprovalCollectDto> importList) {
        if (CollectionUtils.isEmpty(importList)) {
            return;
        }
        List codeList = this.generateCodeService.generateCode("HXCJ", importList.size(), Integer.valueOf(5), 2L, TimeUnit.DAYS);
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(importList, MnApprovalCollectDto.class, MnApprovalCollect.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList entityList = Lists.newArrayList((Iterable)entities);
        String tenantCode = TenantUtils.getTenantCode();
        for (int i = 0; i < importList.size(); ++i) {
            MnApprovalCollect e = (MnApprovalCollect)((Object)entityList.get(i));
            e.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            e.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            e.setTenantCode(tenantCode);
            e.setCode((String)codeList.get(i));
        }
        this.mnApprovalCollectRepository.saveBatch(entities);
        importList.forEach(dto -> {
            MnApprovalCollectLogEventDto logEventDto = new MnApprovalCollectLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = MnApprovalCollectLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, MnApprovalCollectLogEventListener.class, (SerializableBiConsumer)onCreate);
        });
    }

    public List<MnApprovalCollectVo> getList(MnApprovalCollectDto approvalCollect) {
        String tenantCode = TenantUtils.getTenantCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mnApprovalCollectRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(StringUtils.isNotEmpty((CharSequence)approvalCollect.getBusinessFormatCode()), MnApprovalCollect::getBusinessFormatCode, (Object)approvalCollect.getBusinessFormatCode())).in(!CollectionUtils.isEmpty((Collection)approvalCollect.getBusinessUnitCode()), MnApprovalCollect::getBusinessUnitCode, (Collection)approvalCollect.getBusinessUnitCode())).eq(StringUtils.isNotEmpty((CharSequence)approvalCollect.getType()), MnApprovalCollect::getType, (Object)approvalCollect.getType())).list();
        Collection mnApprovalCollectVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)Optional.of(list).orElse(new ArrayList()), MnApprovalCollect.class, MnApprovalCollectVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)mnApprovalCollectVos;
    }

    private void createValidate(MnApprovalCollectDto approvalCollect) {
        Validate.notNull((Object)approvalCollect, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)approvalCollect.getId()), (String)"\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        approvalCollect.setId(null);
        Validate.notBlank((CharSequence)approvalCollect.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getType(), (String)"\u6838\u9500\u91c7\u96c6\u4fe1\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)MnApprovalCollectType.findByCode((String)approvalCollect.getType()), (String)"\u672a\u77e5\u7684\u6838\u9500\u91c7\u96c6\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)approvalCollect.getSortIndex(), (String)"\u6392\u5e8f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void updateValidate(MnApprovalCollectDto approvalCollect) {
        Validate.notNull((Object)approvalCollect, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getId(), (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getType(), (String)"\u6838\u9500\u91c7\u96c6\u4fe1\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)MnApprovalCollectType.findByCode((String)approvalCollect.getType()), (String)"\u672a\u77e5\u7684\u6838\u9500\u91c7\u96c6\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)approvalCollect.getSortIndex(), (String)"\u6392\u5e8f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

