/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.activity.detail.check.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.activity.detail.check.local.entity.AuditActivityDetailCheck;
import com.biz.crm.tpm.business.audit.activity.detail.check.local.repository.AuditActivityDetailCheckRepository;
import com.biz.crm.tpm.business.audit.activity.detail.check.local.sdk.dto.AuditActivityDetailCheckDto;
import com.biz.crm.tpm.business.audit.activity.detail.check.local.sdk.dto.log.AuditActivityDetailCheckLogEventDto;
import com.biz.crm.tpm.business.audit.activity.detail.check.local.sdk.event.AuditActivityDetailCheckLogEventListener;
import com.biz.crm.tpm.business.audit.activity.detail.check.local.sdk.service.AuditActivityDetailCheckService;
import com.biz.crm.tpm.business.audit.activity.detail.check.local.sdk.vo.AuditActivityDetailCheckVo;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckCostVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckStatementVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateAllowanceService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateSelectVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckStatementVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingRelationActivityConfigVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AuditActivityDetailCheckServiceImpl
implements AuditActivityDetailCheckService {
    private static final Logger log = LoggerFactory.getLogger(AuditActivityDetailCheckServiceImpl.class);
    @Autowired(required=false)
    private AuditActivityDetailCheckRepository auditActivityDetailCheckRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateAllowanceService tpmDeductionMatchingTemplateAllowanceService;
    @Autowired(required=false)
    private TpmDeductionDetailMappingService tpmDeductionDetailMappingService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanVoService auditFeeCheckDetailPlanVoService;
    @Autowired(required=false)
    private AuditFeeCheckStatementVoService auditFeeCheckStatementVoService;
    @Autowired(required=false)
    private AuditFeeCheckCostVoService auditFeeCheckCostVoService;

    public Page<AuditActivityDetailCheckVo> findByConditions(Pageable pageable, AuditActivityDetailCheckDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditActivityDetailCheckDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.auditActivityDetailCheckRepository.findByConditions((Page<AuditActivityDetailCheckVo>)page, dto);
    }

    public AuditActivityDetailCheckVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditActivityDetailCheck activityDetailCheck = (AuditActivityDetailCheck)((Object)this.auditActivityDetailCheckRepository.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)activityDetailCheck))) {
            return null;
        }
        return (AuditActivityDetailCheckVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityDetailCheck, AuditActivityDetailCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditActivityDetailCheckVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<AuditActivityDetailCheck> list = this.auditActivityDetailCheckRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditActivityDetailCheck.class, AuditActivityDetailCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(AuditActivityDetailCheckDto dto) {
        boolean update;
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        boolean bl = update = !StringUtils.isBlank((CharSequence)dto.getId());
        if (!update) {
            AuditActivityDetailCheck entity = (AuditActivityDetailCheck)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditActivityDetailCheck.class, HashSet.class, ArrayList.class, new String[0]));
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            AuditActivityDetailCheckLogEventDto logEventDto = new AuditActivityDetailCheckLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = AuditActivityDetailCheckLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditActivityDetailCheckLogEventListener.class, (SerializableBiConsumer)onCreate);
            this.auditActivityDetailCheckRepository.save((Object)entity);
        } else {
            AuditActivityDetailCheck one = (AuditActivityDetailCheck)((Object)this.auditActivityDetailCheckRepository.getById((Serializable)((Object)dto.getId())));
            Validate.notNull((Object)((Object)one), (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6570\u636e\uff01", (Object[])new Object[0]);
            AuditActivityDetailCheckVo oldVo = (AuditActivityDetailCheckVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditActivityDetailCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
            AuditActivityDetailCheckLogEventDto logEventDto = new AuditActivityDetailCheckLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onUpdate = AuditActivityDetailCheckLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditActivityDetailCheckLogEventListener.class, (SerializableBiConsumer)onUpdate);
            AuditActivityDetailCheck entity = (AuditActivityDetailCheck)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditActivityDetailCheck.class, HashSet.class, ArrayList.class, new String[0]));
            this.auditActivityDetailCheckRepository.updateById((Object)entity);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        List<AuditActivityDetailCheckVo> checkVoList = this.findByIds(ids);
        Validate.notEmpty(checkVoList, (String)"\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        checkVoList.forEach(vo -> {
            AuditActivityDetailCheckDto newDto = (AuditActivityDetailCheckDto)this.nebulaToolkitService.copyObjectByWhiteList(vo, AuditActivityDetailCheckDto.class, HashSet.class, ArrayList.class, new String[0]);
            newDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            AuditActivityDetailCheckVo oldVo = (AuditActivityDetailCheckVo)this.nebulaToolkitService.copyObjectByWhiteList(vo, AuditActivityDetailCheckVo.class, HashSet.class, ArrayList.class, new String[0]);
            AuditActivityDetailCheckLogEventDto logEventDto = new AuditActivityDetailCheckLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onDelete = AuditActivityDetailCheckLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditActivityDetailCheckLogEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.auditActivityDetailCheckRepository.deleteByIds(ids);
    }

    public void autoExtractData() {
        List applyMappingTemplateList = this.tpmDeductionMatchingTemplateAllowanceService.findAllApplyMappingCode(TenantUtils.getTenantCode());
        Map<String, TpmDeductionMatchingTemplateSelectVo> applyMappingTemplateMap = applyMappingTemplateList.stream().collect(Collectors.toMap(TpmDeductionMatchingTemplateSelectVo::getApplyMappingCode, Function.identity(), (v1, v2) -> v2));
        List deductionDetailMappingVos = this.tpmDeductionDetailMappingService.findByCodes((List)Lists.newArrayList(applyMappingTemplateMap.keySet()));
        if (CollectionUtils.isEmpty((Collection)deductionDetailMappingVos)) {
            return;
        }
        Map deductionDetailMappingVoMap = deductionDetailMappingVos.stream().collect(Collectors.toMap(TpmDeductionDetailMappingVo::getCode, Function.identity(), (v1, v2) -> v2));
        for (String key : applyMappingTemplateMap.keySet()) {
            TpmDeductionMatchingTemplateSelectVo templateSelectVo = (TpmDeductionMatchingTemplateSelectVo)applyMappingTemplateMap.get(key);
            TpmDeductionDetailMappingVo tpmDeductionDetailMappingVo = (TpmDeductionDetailMappingVo)deductionDetailMappingVoMap.get(key);
            if (ObjectUtils.isEmpty((Object)templateSelectVo) || ObjectUtils.isEmpty((Object)tpmDeductionDetailMappingVo)) continue;
            templateSelectVo.setApplyMappingName(tpmDeductionDetailMappingVo.getName());
        }
        Map<String, List<TpmDeductionDetailMappingVo>> groupMapOne = deductionDetailMappingVos.stream().collect(Collectors.groupingBy(k -> k.getBusinessFormatCode() + k.getBusinessUnitCode() + k.getResaleCommercialCode() + k.getSalesOrgCode() + k.getAuditType() + k.getChannelCode() + k.getBuyWay()));
        this.extractDataFromActivityDetailPlan(groupMapOne, applyMappingTemplateMap);
        this.extractDataFromSubComActivityDetailPlan(groupMapOne, applyMappingTemplateMap);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveAndUpdate(List<AuditActivityDetailCheck> existList, List<AuditActivityDetailCheck> saveList) {
        if (!CollectionUtils.isEmpty(existList)) {
            this.auditActivityDetailCheckRepository.updateBatchById(existList);
        }
        if (!CollectionUtils.isEmpty(saveList)) {
            this.auditActivityDetailCheckRepository.saveBatch(saveList);
        }
    }

    private void extractDataFromActivityDetailPlan(Map<String, List<TpmDeductionDetailMappingVo>> groupMapOne, Map<String, TpmDeductionMatchingTemplateSelectVo> applyMappingTemplateMap) {
        Set<String> oneKeySet = groupMapOne.keySet();
        HashMap<String, List> selectDtoMap = new HashMap<String, List>(oneKeySet.size());
        for (String oneKey : oneKeySet) {
            List<TpmDeductionDetailMappingVo> mappingVoList = groupMapOne.get(oneKey);
            ArrayList configList = new ArrayList(mappingVoList.size());
            mappingVoList.forEach(vo -> {
                List list = vo.getDeductionDetailMappingRelationActivityConfigList();
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    configList.addAll(list);
                }
            });
            Map<String, List<TpmDeductionDetailMappingRelationActivityConfigVo>> groupMapTwo = configList.stream().collect(Collectors.groupingBy(v -> v.getActivityTypeCode() + v.getActivityFormCode()));
            ArrayList<ActivityDetailPlanItemDto> selectDtoList = new ArrayList<ActivityDetailPlanItemDto>(groupMapTwo.keySet().size());
            for (String twoKey : groupMapTwo.keySet()) {
                List<TpmDeductionDetailMappingRelationActivityConfigVo> mappingRelationVo = groupMapTwo.get(twoKey);
                ActivityDetailPlanItemDto selectDto = new ActivityDetailPlanItemDto();
                selectDto.setBusinessFormatCode(mappingVoList.get(0).getBusinessFormatCode());
                selectDto.setBusinessUnitCode(mappingVoList.get(0).getBusinessUnitCode());
                selectDto.setSystemCode(mappingVoList.get(0).getResaleCommercialCode());
                selectDto.setSalesInstitutionCode(mappingVoList.get(0).getSalesOrgCode());
                selectDto.setAuditType(mappingVoList.get(0).getAuditType());
                selectDto.setDistributionChannelCode(mappingVoList.get(0).getChannelCode());
                selectDto.setPaymentMethod(mappingVoList.get(0).getBuyWay());
                selectDto.setActivityFormCode(mappingRelationVo.get(0).getActivityFormCode());
                selectDto.setActivityTypeCode(mappingRelationVo.get(0).getActivityTypeCode());
                selectDtoList.add(selectDto);
            }
            selectDtoMap.put(mappingVoList.get(0).getCode(), selectDtoList);
        }
        if (!CollectionUtils.isEmpty(selectDtoMap)) {
            selectDtoMap.forEach((k, v) -> v.forEach(select -> this.extractDataByActivityDetailItem((String)k, (ActivityDetailPlanItemDto)select, applyMappingTemplateMap)));
        }
    }

    private void extractDataByActivityDetailItem(String mappingCode, ActivityDetailPlanItemDto selectDto, Map<String, TpmDeductionMatchingTemplateSelectVo> applyMappingTemplateMap) {
        if (Objects.isNull(selectDto)) {
            return;
        }
        Integer total = this.activityDetailPlanItemSdkService.getExtractAuditDetailPlanCheckDataTotal(selectDto);
        if (total <= 0) {
            return;
        }
        int pageSize = 1000;
        int pageNumber = total / pageSize;
        for (int i = 0; i <= pageNumber; ++i) {
            ArrayList<AuditActivityDetailCheck> saveList = new ArrayList<AuditActivityDetailCheck>(1000);
            List activityDetailPlanItemList = this.activityDetailPlanItemSdkService.extractAuditDetailPlanCheckData(selectDto, i, pageSize);
            if (CollectionUtils.isEmpty((Collection)activityDetailPlanItemList)) {
                return;
            }
            List<String> itemCodes = activityDetailPlanItemList.stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
            List<AuditActivityDetailCheck> existList = this.auditActivityDetailCheckRepository.findByActivityItemCodes(itemCodes);
            Map existMap = existList.stream().collect(Collectors.toMap(AuditActivityDetailCheck::getActivityDetailItemCode, Function.identity(), (k1, k2) -> k2));
            List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode((Set)Sets.newHashSet(itemCodes));
            Map<String, DetailedForecastVo> detailedForecastVoMap = null;
            if (!CollectionUtils.isEmpty((Collection)detailedForecastVoList)) {
                detailedForecastVoMap = detailedForecastVoList.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, Function.identity(), (v1, v2) -> v2));
            }
            List feeCheckDetailPlanList = this.auditFeeCheckDetailPlanVoService.findByDetailItemCodes(itemCodes);
            Map<String, List<AuditFeeCheckDetailPlanVo>> feeCheckDetailPlanMap = feeCheckDetailPlanList.stream().collect(Collectors.groupingBy(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode));
            List auditFeeCheckCodeList = feeCheckDetailPlanList.stream().map(AuditFeeCheckDetailPlanVo::getAuditFeeCheckCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List statementVoList = this.auditFeeCheckStatementVoService.findDetailByMatchCodes(auditFeeCheckCodeList);
            List<String> relatedStatementCodes = statementVoList.stream().map(AuditFeeCheckStatementVo::getAuditFeeCheckCode).filter(Objects::nonNull).collect(Collectors.toList());
            List costVoList = this.auditFeeCheckCostVoService.findDetailByMatchCodes(auditFeeCheckCodeList);
            List<String> relatedCostCodes = costVoList.stream().map(AuditFeeCheckCostVo::getAuditFeeCheckCode).filter(Objects::nonNull).collect(Collectors.toList());
            ArrayList auditCustomerDetailList = new ArrayList();
            HashMap<String, AuditCustomerDetailVo> auditCustomerDetailMap = new HashMap();
            if (!CollectionUtils.isEmpty(auditCustomerDetailList)) {
                auditCustomerDetailMap = auditCustomerDetailList.stream().collect(Collectors.toMap(AuditCustomerDetailVo::getActivityDetailCode, Function.identity(), (v1, v2) -> v2));
            }
            for (ActivityDetailPlanItemVo item : activityDetailPlanItemList) {
                AuditActivityDetailCheck planItemCheck = (AuditActivityDetailCheck)((Object)existMap.get(item.getDetailPlanItemCode()));
                if (Objects.isNull((Object)planItemCheck)) {
                    AuditActivityDetailCheck save = this.buildAssInfoByItem(mappingCode, item, null, applyMappingTemplateMap, detailedForecastVoMap, feeCheckDetailPlanMap, auditCustomerDetailMap, relatedStatementCodes, relatedCostCodes);
                    saveList.add(save);
                    continue;
                }
                this.buildAssInfoByItem(mappingCode, item, planItemCheck, applyMappingTemplateMap, detailedForecastVoMap, feeCheckDetailPlanMap, auditCustomerDetailMap, relatedStatementCodes, relatedCostCodes);
            }
            this.saveAndUpdate(existList, saveList);
        }
    }

    private void extractDataFromSubComActivityDetailPlan(Map<String, List<TpmDeductionDetailMappingVo>> groupMapOne, Map<String, TpmDeductionMatchingTemplateSelectVo> applyMappingTemplateMap) {
        Set<String> oneKeySet = groupMapOne.keySet();
        HashMap<String, List> selectDtoMap = new HashMap<String, List>(oneKeySet.size());
        for (String oneKey : oneKeySet) {
            List<TpmDeductionDetailMappingVo> mappingVoList = groupMapOne.get(oneKey);
            ArrayList configList = new ArrayList(mappingVoList.size());
            mappingVoList.forEach(vo -> {
                List list = vo.getDeductionDetailMappingRelationActivityConfigList();
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    configList.addAll(list);
                }
            });
            Map<String, List<TpmDeductionDetailMappingRelationActivityConfigVo>> groupMapTwo = configList.stream().collect(Collectors.groupingBy(v -> v.getActivityTypeCode() + v.getActivityFormCode()));
            ArrayList<SubComActivityDetailPlanItemDto> selectDtoList = new ArrayList<SubComActivityDetailPlanItemDto>(groupMapTwo.keySet().size());
            for (String twoKey : groupMapTwo.keySet()) {
                List<TpmDeductionDetailMappingRelationActivityConfigVo> mappingRelationVo = groupMapTwo.get(twoKey);
                SubComActivityDetailPlanItemDto selectDto = new SubComActivityDetailPlanItemDto();
                selectDto.setBusinessFormatCode(mappingVoList.get(0).getBusinessFormatCode());
                selectDto.setBusinessUnitCode(mappingVoList.get(0).getBusinessUnitCode());
                selectDto.setResaleCommercialCode(mappingVoList.get(0).getResaleCommercialCode());
                selectDto.setSalesInstitutionCode(mappingVoList.get(0).getSalesOrgCode());
                selectDto.setAuditType(mappingVoList.get(0).getAuditType());
                selectDto.setDistributionChannelCode(mappingVoList.get(0).getChannelCode());
                selectDto.setPaymentMethod(mappingVoList.get(0).getBuyWay());
                selectDto.setActivityFormCode(mappingRelationVo.get(0).getActivityFormCode());
                selectDto.setActivityType(mappingRelationVo.get(0).getActivityTypeCode());
                selectDtoList.add(selectDto);
            }
            selectDtoMap.put(mappingVoList.get(0).getCode(), selectDtoList);
        }
        if (!CollectionUtils.isEmpty(selectDtoMap)) {
            selectDtoMap.forEach((k, v) -> v.forEach(select -> this.extractDataBYSubComActivityDetailItem((String)k, (SubComActivityDetailPlanItemDto)select, applyMappingTemplateMap)));
        }
    }

    private void extractDataBYSubComActivityDetailItem(String mappingCode, SubComActivityDetailPlanItemDto selectDto, Map<String, TpmDeductionMatchingTemplateSelectVo> applyMappingTemplateMap) {
        if (Objects.isNull(selectDto)) {
            return;
        }
        Integer total = this.subComActivityDetailPlanItemVoService.getExtractAuditDetailPlanCheckDataTotal(selectDto);
        if (total <= 0) {
            return;
        }
        int pageSize = 1000;
        int pageNumber = total / pageSize;
        for (int i = 0; i <= pageNumber; ++i) {
            ArrayList<AuditActivityDetailCheck> saveList = new ArrayList<AuditActivityDetailCheck>(1000);
            List activityDetailPlanItemList = this.subComActivityDetailPlanItemVoService.extractAuditDetailPlanCheckData(selectDto, i, pageSize);
            if (CollectionUtils.isEmpty((Collection)activityDetailPlanItemList)) {
                return;
            }
            List<String> itemCodes = activityDetailPlanItemList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
            List<AuditActivityDetailCheck> existList = this.auditActivityDetailCheckRepository.findByActivityItemCodes(itemCodes);
            Map existMap = existList.stream().collect(Collectors.toMap(AuditActivityDetailCheck::getActivityDetailItemCode, Function.identity(), (k1, k2) -> k2));
            List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode((Set)Sets.newHashSet(itemCodes));
            Map<String, DetailedForecastVo> detailedForecastVoMap = null;
            if (!CollectionUtils.isEmpty((Collection)detailedForecastVoList)) {
                detailedForecastVoMap = detailedForecastVoList.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, Function.identity(), (v1, v2) -> v2));
            }
            List feeCheckDetailPlanList = this.auditFeeCheckDetailPlanVoService.findByDetailItemCodes(itemCodes);
            Map<String, List<AuditFeeCheckDetailPlanVo>> feeCheckDetailPlanMap = feeCheckDetailPlanList.stream().collect(Collectors.groupingBy(AuditFeeCheckDetailPlanVo::getDetailPlanItemCode));
            List auditFeeCheckCodeList = feeCheckDetailPlanList.stream().map(AuditFeeCheckDetailPlanVo::getAuditFeeCheckCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List statementVoList = this.auditFeeCheckStatementVoService.findDetailByMatchCodes(auditFeeCheckCodeList);
            List<String> relatedStatementCodes = statementVoList.stream().map(AuditFeeCheckStatementVo::getAuditFeeCheckCode).filter(Objects::nonNull).collect(Collectors.toList());
            List costVoList = this.auditFeeCheckCostVoService.findDetailByMatchCodes(auditFeeCheckCodeList);
            List<String> relatedCostCodes = costVoList.stream().map(AuditFeeCheckCostVo::getAuditFeeCheckCode).filter(Objects::nonNull).collect(Collectors.toList());
            ArrayList auditCustomerDetailList = new ArrayList();
            HashMap<String, AuditCustomerDetailVo> auditCustomerDetailMap = new HashMap();
            if (!CollectionUtils.isEmpty(auditCustomerDetailList)) {
                auditCustomerDetailMap = auditCustomerDetailList.stream().collect(Collectors.toMap(AuditCustomerDetailVo::getActivityDetailCode, Function.identity(), (v1, v2) -> v2));
            }
            for (SubComActivityDetailPlanItemVo item : activityDetailPlanItemList) {
                AuditActivityDetailCheck planItemCheck = (AuditActivityDetailCheck)((Object)existMap.get(item.getConstituentDetailPlanItemCode()));
                if (Objects.isNull((Object)planItemCheck)) {
                    AuditActivityDetailCheck save = this.buildAssInfoBySubItem(mappingCode, item, null, applyMappingTemplateMap, detailedForecastVoMap, feeCheckDetailPlanMap, auditCustomerDetailMap, relatedStatementCodes, relatedCostCodes);
                    saveList.add(save);
                    continue;
                }
                this.buildAssInfoBySubItem(mappingCode, item, planItemCheck, applyMappingTemplateMap, detailedForecastVoMap, feeCheckDetailPlanMap, auditCustomerDetailMap, relatedStatementCodes, relatedCostCodes);
            }
            this.saveAndUpdate(existList, saveList);
        }
    }

    private AuditActivityDetailCheck buildAssInfoByItem(String mappingCode, ActivityDetailPlanItemVo item, AuditActivityDetailCheck old, Map<String, TpmDeductionMatchingTemplateSelectVo> applyMappingTemplateMap, Map<String, DetailedForecastVo> detailedForecastVoMap, Map<String, List<AuditFeeCheckDetailPlanVo>> feeCheckDetailPlanMap, Map<String, AuditCustomerDetailVo> auditCustomerDetailMap, List<String> relatedStatementCodes, List<String> relatedCostCodes) {
        AuditCustomerDetailVo auditCustomerDetailVo;
        List<AuditFeeCheckDetailPlanVo> auditFeeCheckDetailPlanVoList;
        TpmDeductionMatchingTemplateSelectVo tpmDeductionMatchingTemplateSelectVo;
        DetailedForecastVo detailedForecastVo;
        if (StringUtils.isBlank((CharSequence)mappingCode) || Objects.isNull(item)) {
            return null;
        }
        AuditActivityDetailCheck entity = old;
        if (Objects.isNull((Object)entity)) {
            entity = new AuditActivityDetailCheck();
        }
        entity.setBusinessFormatCode(item.getBusinessFormatCode());
        entity.setBusinessUnitCode(item.getBusinessUnitCode());
        entity.setActivityDetailItemName(item.getDetailPlanName());
        entity.setActivityStartTime(item.getActivityBeginDate());
        entity.setActivityEndTime(item.getActivityEndDate());
        entity.setActivityFormCode(item.getActivityFormCode());
        entity.setActivityFormName(item.getActivityFormName());
        entity.setDistributionChannelCode(item.getDistributionChannelCode());
        entity.setDistributionChannelName(item.getDistributionChannelName());
        entity.setSalesInstitutionCode(item.getActivityOrgCode());
        entity.setSalesInstitutionName(item.getActivityOrgName());
        entity.setAuditType(item.getAuditType());
        entity.setBuyWay(item.getPaymentMethod());
        entity.setSystemCode(item.getSystemCode());
        entity.setSystemName(item.getSystemName());
        entity.setTerminalCode(item.getTerminalCode());
        entity.setTerminalName(item.getTerminalName());
        entity.setProductCode(item.getProductCode());
        entity.setProductName(item.getProductName());
        entity.setWriteOffMethod(item.getAuditType());
        entity.setTotalFeeAmount(item.getFeeAmount());
        entity.setApplyAuditWay(item.getAuditForm());
        entity.setWholeAudit(item.getWholeAudit());
        entity.setRegion(item.getRegion());
        entity.setAlreadyAuditAmount(item.getAlreadyAuditAmount());
        entity.setCustomerCode(item.getCustomerCode());
        entity.setCustomerName(item.getCustomerName());
        if (!ObjectUtils.isEmpty((Object)item.getFeeYearMonth())) {
            entity.setFeeYearMonth(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM, (Date)item.getFeeYearMonth()));
        }
        if (!CollectionUtils.isEmpty(detailedForecastVoMap) && !Objects.isNull(detailedForecastVo = detailedForecastVoMap.get(item.getDetailPlanItemCode()))) {
            entity.setActivityPreAuditAmount(detailedForecastVo.getEstimatedWriteOffAmount());
        }
        if (!CollectionUtils.isEmpty(applyMappingTemplateMap) && !Objects.isNull(tpmDeductionMatchingTemplateSelectVo = applyMappingTemplateMap.get(mappingCode))) {
            entity.setApplyMappingCode(tpmDeductionMatchingTemplateSelectVo.getApplyMappingCode());
            entity.setApplyMappingName(tpmDeductionMatchingTemplateSelectVo.getApplyMappingName());
            entity.setMatchTemplateCode(tpmDeductionMatchingTemplateSelectVo.getCode());
            entity.setMatchTemplateName(tpmDeductionMatchingTemplateSelectVo.getName());
        }
        if (!CollectionUtils.isEmpty(feeCheckDetailPlanMap) && !CollectionUtils.isEmpty(auditFeeCheckDetailPlanVoList = feeCheckDetailPlanMap.get(item.getDetailPlanItemCode()))) {
            BigDecimal costOrderApportionAmount = auditFeeCheckDetailPlanVoList.stream().map(AuditFeeCheckDetailPlanVo::getAuditFeeCheckShareAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setCostOrderApportionAmount(costOrderApportionAmount);
            BigDecimal settlementOrderApportionAmount = BigDecimal.ZERO;
            entity.setSettlementOrderApportionAmount(settlementOrderApportionAmount);
            StringBuilder matchCodes = new StringBuilder();
            Iterator<AuditFeeCheckDetailPlanVo> it = auditFeeCheckDetailPlanVoList.iterator();
            while (it.hasNext()) {
                AuditFeeCheckDetailPlanVo next = it.next();
                if (!CollectionUtils.isEmpty(relatedStatementCodes) && !CollectionUtils.isEmpty(relatedCostCodes) && relatedStatementCodes.contains(next.getAuditFeeCheckCode()) && relatedCostCodes.contains(next.getAuditFeeCheckCode())) {
                    entity.setJoinCostMatch(BooleanEnum.TRUE.getCapital());
                    entity.setJoinStatementMatch(BooleanEnum.TRUE.getCapital());
                } else if (!CollectionUtils.isEmpty(relatedStatementCodes) && relatedStatementCodes.contains(next.getAuditFeeCheckCode())) {
                    entity.setJoinStatementMatch(BooleanEnum.TRUE.getCapital());
                } else if (!CollectionUtils.isEmpty(relatedCostCodes) && relatedCostCodes.contains(next.getAuditFeeCheckCode())) {
                    entity.setJoinCostMatch(BooleanEnum.TRUE.getCapital());
                }
                matchCodes.append(next.getAuditFeeCheckCode());
                if (!it.hasNext()) continue;
                matchCodes.append(",");
            }
            entity.setMatchCode(matchCodes.toString());
        }
        if (!CollectionUtils.isEmpty(auditCustomerDetailMap) && !Objects.isNull(auditCustomerDetailVo = auditCustomerDetailMap.get(item.getDetailPlanItemCode()))) {
            entity.setWriteOffAuditWay(auditCustomerDetailVo.getEndCaseForm());
            entity.setDiscountUpAccountAmount(auditCustomerDetailVo.getDiscountTaxAmount());
            entity.setWriteOffUpAccountAmount(auditCustomerDetailVo.getReimburseTaxAmount());
        }
        if (Objects.isNull((Object)old)) {
            entity.setActivityDetailItemCode(item.getDetailPlanItemCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            return entity;
        }
        return null;
    }

    private AuditActivityDetailCheck buildAssInfoBySubItem(String mappingCode, SubComActivityDetailPlanItemVo item, AuditActivityDetailCheck old, Map<String, TpmDeductionMatchingTemplateSelectVo> applyMappingTemplateMap, Map<String, DetailedForecastVo> detailedForecastVoMap, Map<String, List<AuditFeeCheckDetailPlanVo>> feeCheckDetailPlanMap, Map<String, AuditCustomerDetailVo> auditCustomerDetailMap, List<String> relatedStatementCodes, List<String> relatedCostCodes) {
        TpmDeductionMatchingTemplateSelectVo tpmDeductionMatchingTemplateSelectVo;
        DetailedForecastVo detailedForecastVo;
        if (StringUtils.isBlank((CharSequence)mappingCode) || Objects.isNull(item)) {
            return null;
        }
        AuditActivityDetailCheck entity = old;
        if (Objects.isNull((Object)entity)) {
            entity = new AuditActivityDetailCheck();
        }
        entity.setBusinessFormatCode(item.getBusinessFormatCode());
        entity.setBusinessUnitCode(item.getBusinessUnitCode());
        entity.setActivityDetailItemName(item.getConstituentDetailPlanName());
        entity.setActivityStartTime(item.getActivityBeginTime());
        entity.setActivityEndTime(item.getActivityEndTime());
        entity.setActivityFormCode(item.getActivityFormCode());
        entity.setActivityFormName(item.getActivityFormName());
        entity.setDistributionChannelCode(item.getDistributionChannelCode());
        entity.setDistributionChannelName(item.getDistributionChannelName());
        entity.setSalesInstitutionCode(item.getSalesInstitutionCode());
        entity.setSalesInstitutionName(item.getSalesInstitutionName());
        entity.setAuditType(item.getAuditType());
        entity.setBuyWay(item.getPaymentMethod());
        entity.setSystemCode(item.getResaleCommercialCode());
        entity.setSystemName(item.getResaleCommercialName());
        entity.setTerminalCode(item.getTerminalCode());
        entity.setTerminalName(item.getTerminalName());
        entity.setProductCode(item.getProductCode());
        entity.setProductName(item.getProductName());
        entity.setWriteOffMethod(item.getAuditType());
        entity.setTotalFeeAmount(item.getTotalCost());
        entity.setApplyAuditWay(item.getAuditForm());
        entity.setWholeAudit(item.getWholeAudit());
        entity.setAlreadyAuditAmount(item.getAlreadyAuditAmount());
        entity.setCustomerCode(item.getCustomerCode());
        entity.setCustomerName(item.getCustomerName());
        if (!ObjectUtils.isEmpty((Object)item.getFeeYearMonth())) {
            entity.setFeeYearMonth(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM, (Date)item.getFeeYearMonth()));
        }
        if (!CollectionUtils.isEmpty(detailedForecastVoMap) && !Objects.isNull(detailedForecastVo = detailedForecastVoMap.get(item.getConstituentDetailPlanItemCode()))) {
            entity.setActivityPreAuditAmount(detailedForecastVo.getEstimatedWriteOffAmount());
        }
        if (!CollectionUtils.isEmpty(applyMappingTemplateMap) && !Objects.isNull(tpmDeductionMatchingTemplateSelectVo = applyMappingTemplateMap.get(mappingCode))) {
            entity.setApplyMappingCode(tpmDeductionMatchingTemplateSelectVo.getApplyMappingCode());
            entity.setApplyMappingName(tpmDeductionMatchingTemplateSelectVo.getApplyMappingName());
            entity.setMatchTemplateCode(tpmDeductionMatchingTemplateSelectVo.getCode());
            entity.setMatchTemplateName(tpmDeductionMatchingTemplateSelectVo.getName());
        }
        if (!CollectionUtils.isEmpty(feeCheckDetailPlanMap)) {
            List<AuditFeeCheckDetailPlanVo> auditFeeCheckDetailPlanVoList = feeCheckDetailPlanMap.get(item.getConstituentDetailPlanItemCode());
            BigDecimal costOrderApportionAmount = auditFeeCheckDetailPlanVoList.stream().map(AuditFeeCheckDetailPlanVo::getAuditFeeCheckShareAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setCostOrderApportionAmount(costOrderApportionAmount);
            BigDecimal settlementOrderApportionAmount = BigDecimal.ZERO;
            entity.setSettlementOrderApportionAmount(settlementOrderApportionAmount);
            entity.setRegion(auditFeeCheckDetailPlanVoList.get(0).getRegion());
            StringBuilder matchCodes = new StringBuilder();
            Iterator<AuditFeeCheckDetailPlanVo> it = auditFeeCheckDetailPlanVoList.iterator();
            while (it.hasNext()) {
                AuditFeeCheckDetailPlanVo next = it.next();
                if (!CollectionUtils.isEmpty(relatedStatementCodes) && !CollectionUtils.isEmpty(relatedCostCodes) && relatedStatementCodes.contains(next.getAuditFeeCheckCode()) && relatedCostCodes.contains(next.getAuditFeeCheckCode())) {
                    entity.setJoinCostMatch(BooleanEnum.TRUE.getCapital());
                    entity.setJoinStatementMatch(BooleanEnum.TRUE.getCapital());
                } else if (!CollectionUtils.isEmpty(relatedStatementCodes) && relatedStatementCodes.contains(next.getAuditFeeCheckCode())) {
                    entity.setJoinStatementMatch(BooleanEnum.TRUE.getCapital());
                } else if (!CollectionUtils.isEmpty(relatedCostCodes) && relatedCostCodes.contains(next.getAuditFeeCheckCode())) {
                    entity.setJoinCostMatch(BooleanEnum.TRUE.getCapital());
                }
                matchCodes.append(next.getAuditFeeCheckCode());
                if (!it.hasNext()) continue;
                matchCodes.append(",");
            }
            entity.setMatchCode(matchCodes.toString());
        }
        if (!CollectionUtils.isEmpty(auditCustomerDetailMap)) {
            AuditCustomerDetailVo auditCustomerDetailVo = auditCustomerDetailMap.get(item.getConstituentDetailPlanItemCode());
            entity.setWriteOffAuditWay(auditCustomerDetailVo.getEndCaseForm());
            entity.setDiscountUpAccountAmount(auditCustomerDetailVo.getDiscountTaxAmount());
            entity.setWriteOffUpAccountAmount(auditCustomerDetailVo.getReimburseTaxAmount());
        }
        if (Objects.isNull((Object)old)) {
            entity.setActivityDetailItemCode(item.getConstituentDetailPlanItemCode());
            entity.setTenantCode(TenantUtils.getTenantCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            return entity;
        }
        return null;
    }
}

