package com.biz.crm.tpm.business.audit.activity.detail.check.local.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.activity.detail.check.local.sdk.dto.AuditActivityDetailCheckDto;
import com.biz.crm.tpm.business.audit.activity.detail.check.local.sdk.vo.AuditActivityDetailCheckVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/4/10
 */
public interface AuditActivityDetailCheckService {

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto 查询条件
     * @return
     */
    Page<AuditActivityDetailCheckVo> findByConditions(Pageable pageable,AuditActivityDetailCheckDto dto);

    /**
     * 更据id获取详情
     *
     * @param id
     * @return
     */
    AuditActivityDetailCheckVo findById(String id);

    /**
     * 更据id集合获取详情
     *
     * @param ids
     * @return
     */
    List<AuditActivityDetailCheckVo> findByIds(List<String> ids);

    /**
     * 新增编辑数据
     *
     * @param dto
     */
    void save(AuditActivityDetailCheckDto dto);

    /**
     * 删除数据
     *
     * @param ids
     */
    void delete(List<String> ids);

    /**
     * 抽取数据
     */
    void autoExtractData();

}
