package com.biz.crm.tpm.business.audit.activity.detail.check.local.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/4/10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AuditActivityDetailCheckVo", description = "活动明细核对台账vo")
public class AuditActivityDetailCheckVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    @ApiModelProperty(name = "活动细案明细编码", notes = "活动细案明细编码")
    private String activityDetailItemCode;

    @ApiModelProperty(name = "活动细案明细名称", notes = "活动细案明细名称")
    private String activityDetailItemName;

    /**
     * 活动开始时间
     */
    @ApiModelProperty(name = "activityStartTime", value = "活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    @ApiModelProperty(name = "activityEndTime", value = "活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndTime;

    /**
     * 费用归属年月
     */
    @ApiModelProperty(name = "feeYearMonth", value = "费用归属年月")
    private String feeYearMonth;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;


    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    private String distributionChannelName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesInstitutionCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String salesInstitutionName;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    private String auditType;

    /**
     * 购买方式
     */
    @ApiModelProperty("购买方式")
    private String buyWay;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 零售商编码
     */
    @ApiModelProperty("零售商编码")
    private String systemCode;
    /**
     * 零售商名称
     */
    @ApiModelProperty("零售商名称")
    private String systemName;

    /**
     * 门店编码
     */
    @ApiModelProperty("门店编码")
    private String terminalCode;
    /**
     * 门店名称
     */
    @ApiModelProperty("门店名称")
    private String terminalName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    private String writeOffMethod;

    @ApiModelProperty("售达方名称")
    private String customerName;

    @ApiModelProperty("售达方编码")
    private String customerCode;

    /**
     * 活动申请金额
     */
    @ApiModelProperty("活动申请金额")
    private BigDecimal totalFeeAmount;

    /**
     * 细案预结案金额
     */
    @ApiModelProperty(name = "activity_pre_audit_amount", notes = "细案预结案金额", value = "细案预结案金额")
    private BigDecimal activityPreAuditAmount;

    /**
     * 适用映射
     */
    @ApiModelProperty(name ="适用映射编码",notes = "适用映射编码")
    private String applyMappingCode;

    @ApiModelProperty(name ="适用映射名称",notes = "适用映射名称")
    private String applyMappingName;

    /**
     * 匹配模板名称
     */
    @ApiModelProperty(name = "适用匹配模板名称", notes = "适用匹配模板名称")
    private String matchTemplateName;

    /**
     * 匹配模板编码
     */
    @ApiModelProperty(name = "适用匹配模板编码", notes = "适用匹配模板编码")
    private String matchTemplateCode;

    /**
     * 扣费匹配单号 , 多个逗号隔开
     */
    @ApiModelProperty(name = "扣费匹配单号", notes = "扣费匹配单号")
    private String matchCode;

    @ApiModelProperty("费用单分摊金额")
    private BigDecimal costOrderApportionAmount;

    @ApiModelProperty("结算单分摊金额")
    private BigDecimal settlementOrderApportionAmount;

    /**
     * 是否参与费用单匹配
     */
    @ApiModelProperty(name = "是否参与费用单匹配", notes = "是否参与费用单匹配")
    private String joinCostMatch;
    /**
     * 是否参与结算单匹配
     */
    @ApiModelProperty(name = "是否参与结算单匹配", notes = "是否参与结算单匹配")
    private String joinStatementMatch;
    /**
     * 是否核定
     */
    @ApiModelProperty(name = "是否核定", notes = "是否核定")
    private String isAffirm;
    /**
     * 申请结案形式
     */
    @ApiModelProperty("申请结案形式")
    private String applyAuditWay;
    /**
     * 核销结案形式
     */
    @ApiModelProperty("核销结案形式")
    private String writeOffAuditWay;
    /**
     * 是否完全核销
     */
    @ApiModelProperty("是否完全核销")
    private String wholeAudit;
    /**
     * 核销金额
     */
    @ApiModelProperty("核销金额")
    private BigDecimal alreadyAuditAmount;
    /**
     * 折扣上账金额
     */
    @ApiModelProperty("折扣上账金额")
    private BigDecimal discountUpAccountAmount;
    /**
     * 报销上账金额
     */
    @ApiModelProperty("报销上账金额")
    private BigDecimal writeOffUpAccountAmount;
}
