package com.biz.crm.tpm.business.audit.execute.information.feign;

import com.biz.crm.tpm.business.audit.execute.information.feign.impl.SfaPushAuditExecuteInformationFeignImpl;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.sfa.SfaAuditExecuteInformationDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.sfa.SfaAuditExecuteInformationMainDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.sfa.SfaAuditExecuteInformationMainVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

import com.biz.crm.business.common.sdk.model.Result;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/1/5 17:20
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = SfaPushAuditExecuteInformationFeignImpl.class)
public interface SfaPushAuditExecuteInformationFeign {

    @PostMapping(value = "/v1/auditExecuteInformation/auditExecuteInformation/pushSfaAuditExecuteInformationList")
    Result pushSfaAuditExecuteInformationList(@RequestBody List<SfaAuditExecuteInformationDto> dtoList) ;

    @PostMapping(value = "/v1/auditExecuteInformation/auditExecuteInformation/pushSfaAuditExecuteInformationMainList")
    Result<List<SfaAuditExecuteInformationMainVo>> pushSfaAuditExecuteInformationMainList(@RequestBody List<SfaAuditExecuteInformationMainDto> dtoList) ;

}
