package com.biz.crm.tpm.business.audit.execute.information.serivce.impl;

import com.biz.crm.tpm.business.audit.execute.information.feign.SfaPushAuditExecuteInformationFeign;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.sfa.SfaAuditExecuteInformationDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.sfa.SfaAuditExecuteInformationMainDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.SfaPushAuditExecuteInformationService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.sfa.SfaAuditExecuteInformationMainVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.biz.crm.business.common.sdk.model.Result;
import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/1/5 17:19
 */
@Service
public class SfaPushAuditExecuteInformationServiceImpl implements SfaPushAuditExecuteInformationService {

    @Autowired(required = false)
    private SfaPushAuditExecuteInformationFeign sfaPushAuditExecuteInformationFeign;

    @Override
    public Result pushSfaAuditExecuteInformationList(List<SfaAuditExecuteInformationDto> dtoList) {
        return sfaPushAuditExecuteInformationFeign.pushSfaAuditExecuteInformationList(dtoList);
    }

    /**
     * 推送SFA结案资料主体接口
     *
     * @param dtoList 结案资料集合
     */
    @Override
    public Result<List<SfaAuditExecuteInformationMainVo>> pushSfaAuditExecuteInformationMainList(List<SfaAuditExecuteInformationMainDto> dtoList) {
        return sfaPushAuditExecuteInformationFeign.pushSfaAuditExecuteInformationMainList(dtoList);
    }

}
