package com.biz.crm.tpm.business.audit.execute.information.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.sfa.SfaAuditExecuteInformationDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.sfa.SfaAuditExecuteInformationMainDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationFileVo;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationImageVo;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationVo;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.sfa.SfaAuditExecuteInformationMainVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * 执行资料表(AuditExecuteInformation)表控制层
 *
 * @author makejava
 * @date 2022-11-16 16:39:47
 */
@Slf4j
@Api(tags = "执行资料表")
@RestController
@RequestMapping(value = {"/v1/auditExecuteInformation/auditExecuteInformation"})
public class AuditExecuteInformationController {

    @Autowired(required = false)
    private AuditExecuteInformationVoService auditExecuteInformationVoService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<AuditExecuteInformationVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                    AuditExecuteInformationDto paginationDto) {
        try {
            Page<AuditExecuteInformationVo> result = this.auditExecuteInformationVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<AuditExecuteInformationVo> findDetailById(@RequestParam("id") String id) {
        try {
            AuditExecuteInformationVo auditExecuteInformationVo = this.auditExecuteInformationVoService.findDetailById(id);
            return Result.ok(auditExecuteInformationVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取执行资料关联文件列表
     *
     * @param id 执行资料id
     * @return 执行资料文件列表
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findFilesDetailById"})
    public Result<List<AuditExecuteInformationFileVo>> findFilesDetailById(@RequestParam("id") String id) {
        try {
            List<AuditExecuteInformationFileVo> fileVoList = this.auditExecuteInformationVoService.findFilesDetailById(id);
            return Result.ok(fileVoList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 获取执行资料关联图片列表
     *
     * @param id 执行资料id
     * @return 执行资料图片列表
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findImagesDetailById"})
    public Result<List<AuditExecuteInformationImageVo>> findImagesDetailById(@RequestParam("id") String id) {
        try {
            List<AuditExecuteInformationImageVo> fileVoList = this.auditExecuteInformationVoService.findImagesDetailById(id);
            return Result.ok(fileVoList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param auditExecuteInformationVo 执行资料json
     * @return 执行资料文件vo
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<AuditExecuteInformationVo> create(@RequestBody AuditExecuteInformationVo auditExecuteInformationVo) {
        try {
            AuditExecuteInformationVo current = this.auditExecuteInformationVoService.create(auditExecuteInformationVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param auditExecuteInformationVo 执行资料json
     * @return 执行资料文件vo
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<AuditExecuteInformationVo> update(@RequestBody AuditExecuteInformationVo auditExecuteInformationVo) {
        try {
            AuditExecuteInformationVo current = this.auditExecuteInformationVoService.update(auditExecuteInformationVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditExecuteInformationVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditExecuteInformationVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 逻辑删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "逻辑删除")
    @DeleteMapping("/delete")
    public Result delete(@RequestParam("ids") List<String> ids) {
        try {
            this.auditExecuteInformationVoService.updateDelFlagByIds(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * SFA推送结案资料数据到TPM接口
     * @param dtoList 费用明细集合
     */
    @ApiOperation(value = "SFA推送结案资料数据到TPM接口")
    @PostMapping(value = "pushSfaAuditExecuteInformationList")
    public Result pushSfaAuditExecuteInformationList(@RequestBody List<SfaAuditExecuteInformationDto> dtoList){
        try {
            log.info(JSONObject.toJSONString(dtoList));
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 推送SFA结案资料主体接口
     * @param dtoList 费用明细集合
     */
    @ApiOperation(value = "推送SFA结案资料主体接口")
    @PostMapping(value = "pushSfaAuditExecuteInformationMainList")
    public Result<List<SfaAuditExecuteInformationMainVo>> pushSfaAuditExecuteInformationMainList(@RequestBody List<SfaAuditExecuteInformationMainDto> dtoList){
        try {
            Collection<SfaAuditExecuteInformationMainVo> voList = nebulaToolkitService.copyCollectionByWhiteList(dtoList, SfaAuditExecuteInformationMainDto.class, SfaAuditExecuteInformationMainVo.class, LinkedHashSet.class, ArrayList.class);
            voList.forEach(e -> e.setId(UUID.randomUUID().toString().replace("-", "")));
            log.info(JSONObject.toJSONString(voList));
            return Result.ok(new ArrayList<>(voList));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
