package com.biz.crm.tpm.business.audit.execute.information.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author LiuYiFan
 */
@ApiModel(value = "AuditExecuteInformation", description = "执行资料表")
@TableName("tpm_audit_execute_information")
@Getter
@Setter
@Entity(name = "tpm_audit_execute_information")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_execute_information", comment = "执行资料表")
public class AuditExecuteInformation extends TenantFlagOpEntity {

    /**
     * 活动细案编码
     */
    @ApiModelProperty(name = "detailPlanCode",value = "活动细案编码")
    @Column(name = "detail_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty(name = "detailPlanName",value = "活动细案名称")
    @Column(name = "detail_plan_name",  length = 255, columnDefinition = "varchar(255) COMMENT '活动细案名称'")
    private String detailPlanName;

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty(name = "activityDetailItemCode",value = "活动细案明细编码")
    @Column(name = "activity_detail_item_code", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动细案明细编码'")
    private String activityDetailItemCode;


    /**
     * 活动开始时间
     */
    @ApiModelProperty(name = "activityStartTime", value = "活动开始时间")
    @Column(name = "activity_start_time",   columnDefinition = "datetime COMMENT '活动细案明细编码'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    @ApiModelProperty(name = "activityEndTime", value = "活动结束时间")
    @Column(name = "activity_end_time", columnDefinition = "datetime COMMENT '活动细案明细编码'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndTime;


    /**
     * 业态
     */
    @ApiModelProperty(name = "formats", value = "业态")
    @Column(name = "formats", length = 32, columnDefinition = "varchar(32) COMMENT '业态'")
    private String formats;


    /**
     * 预算项目编码
     */
    @ApiModelProperty(name = "budgetItemCode", value = "预算项目编码")
    @Column(name = "budget_item_code",  length = 64, columnDefinition = "varchar(64) COMMENT '预算项目编码'")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(name = "budgetItemName", value = "预算项目名称")
    @Column(name = "budget_item_name",  length = 255, columnDefinition = "varchar(255) COMMENT '预算项目名称'")
    private String budgetItemName;


    @ApiModelProperty(name = "activityTypeCode", value = "活动类型")
    @Column(name = "activity_type_code",  length = 32, columnDefinition = "varchar(32) COMMENT '活动类型'")
    private String activityTypeCode;


    @ApiModelProperty(name = "activityTypeName", value = "活动类型名称")
    @Column(name = "activity_type_name",  length = 64, columnDefinition = "varchar(64) COMMENT '预算项目名称'")
    private String activityTypeName;


    @ApiModelProperty(name = "orgCode", value = "组织编码")
    @Column(name = "org_code",  length = 64, columnDefinition = "varchar(64) COMMENT '组织编码'")
    private String orgCode;


    @ApiModelProperty(name = "orgName", value = "组织名称")
    @Column(name = "org_name",  length = 64, columnDefinition = "varchar(64) COMMENT '组织名称'")
    private String orgName;


    @ApiModelProperty(name = "customerGrade", value = "客户等级")
    @Column(name = "customer_grade",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户等级'")
    private String customerGrade;


    @ApiModelProperty(name = "customerCode", value = "客户编码")
    @Column(name = "customer_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户编码'")
    private String customerCode;


    @ApiModelProperty(name = "customerName", value = "客户名称")
    @Column(name = "customer_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;


    @ApiModelProperty(name = "supplierCode", value = "供应商编码")
    @Column(name = "supplier_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '供应商编码'")
    private String supplierCode;


    @ApiModelProperty(name = "supplierName", value = "供应商名称")
    @Column(name = "supplier_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '供应商名称'")
    private String supplierName;

    /**
     * 门店编码
     */
    @ApiModelProperty(name = "terminalCode", value = "门店编码")
    @Column(name = "terminal_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店编码'")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "terminalName", value = "门店名称")
    @Column(name = "terminal_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店名称'")
    private String terminalName;


    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "productBrandCode", value = "品牌编码")
    @Column(name = "product_brand_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '品牌编码'")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "productBrandName", value = "品牌名称")
    @Column(name = "product_brand_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称'")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(name = "productCategoryCode", value = "品类编码")
    @Column(name = "product_category_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码 '")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(name = "productCategoryName", notes = "品类名称")
    @Column(name = "product_category_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    private String productCategoryName;



    @ApiModelProperty(name = "productCode", value = "产品编码")
    @Column(name = "product_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品编码 '")
    private String productCode;


    @ApiModelProperty(name = "productName", value = "产品名称")
    @Column(name = "product_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '产品名称 '")
    private String productName;

    /**
     * 总申请金额
     */
    @ApiModelProperty(name = "applyAmount", value = "申请金额")
    @Column(name = "apply_amount",  columnDefinition = "decimal(24,6) COMMENT '申请金额 '")
    private BigDecimal applyAmount;


    /**
     * 调整金额
     */
    @ApiModelProperty(name = "adjust_amount", value = "调整金额")
    @Column(name = "adjust_amount",  columnDefinition = "decimal(24,6) COMMENT '调整金额 '")
    private BigDecimal adjustAmount;

    /**
     * 实际总申请金额
     */
    @ApiModelProperty(name = "actualApplyAmount", value = "实际总申请金额")
    @Column(name = "actual_apply_amount",   columnDefinition = "decimal(24,6) COMMENT '实际总申请金额 '")
    private BigDecimal actualApplyAmount;

    /**
     * 执行时间
     */
    @ApiModelProperty(name = "excuteDate", value = "执行时间")
    @Column(name = "excute_date",   columnDefinition = "datetime COMMENT '执行时间 '")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date excuteDate;

}
