package com.biz.crm.tpm.business.audit.execute.information.local.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author LiuYiFan
 */
@ApiModel(value = "AuditExecuteInformationFile", description = "执行资料文件表")
@TableName("tpm_audit_execute_information_file")
@Getter
@Setter
@Entity(name = "tpm_audit_execute_information_file")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_execute_information_file", comment = "执行资料文件表")
public class AuditExecuteInformationFile extends FileEntity {

    /**
     * 关联执行文件主表
     */
    @ApiModelProperty(name = "auditExecuteId", value = "关联执行文件主表",hidden = true)
    @Column(name = "audit_execute_id", length = 128, columnDefinition = "varchar(128) COMMENT '关联执行文件主表 '")
    private String auditExecuteId;


    /**
     * 文件类型
     */
    @ApiModelProperty(name = "file_type", value = "文件类型")
    @Column(name = "file_type", length = 64, columnDefinition = "varchar(64) COMMENT '文件类型 '")
    private String fileType;
}
