package com.biz.crm.tpm.business.audit.execute.information.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationLogEventDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.log.AuditExecuteInformationLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditExecuteInformationLogEventListenerImpl implements AuditExecuteInformationLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 核销资料创建时生成的日志
     * @param eventDto 核销资料新旧VO
     */
    @Override
    public void onCreate(AuditExecuteInformationLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }

    /**
     * 核销资料删除时生成的日志
     * @param eventDto 核销资料新旧VO
     */
    @Override
    public void onDelete(AuditExecuteInformationLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }

    /**
     * 核销资料修改时生成的日志
     * @param eventDto 核销资料新旧VO
     */
    @Override
    public void onUpdate(AuditExecuteInformationLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, eventDto);
    }


    /**
     * 核销资料启用时生成的日志
     * @param eventDto 核销资料新旧VO
     */
    @Override
    public void onEnable(AuditExecuteInformationLogEventDto eventDto) {

        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 核销资料禁用时生成的日志
     * @param eventDto 核销资料新旧VO
     */
    @Override
    public void onDisable(AuditExecuteInformationLogEventDto eventDto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    private void buildCrmBusinessLog(CrmBusinessLogDto crmBusinessLogDto, AuditExecuteInformationLogEventDto eventDto) {
        crmBusinessLogDto.setOnlyKey(eventDto.getNewest().getId());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(eventDto.getOriginal());
        crmBusinessLogDto.setNewObject(eventDto.getNewest());
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
