package com.biz.crm.tpm.business.audit.execute.information.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 执行资料(AuditInformationDataViewRegister)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-11 10:31:00
 */
@Component
public class AuditInformationDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String desc() {
        return "TPM-执行资料";
    }

    @Override
    public String buildSql() {
        return "SELECT\n" +
                " t.*,\n" +
                " GROUP_CONCAT( f.original_name ) files, \n" +
                " GROUP_CONCAT( i.original_name ) images FROM tpm_audit_execute_information t \n" +
                " LEFT JOIN tpm_audit_execute_information_file f ON t.id = f.audit_execute_id \n" +
                " LEFT JOIN tpm_audit_execute_information_image i ON t.id = i.audit_execute_id " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'   GROUP BY t.id";
    }

}
