package com.biz.crm.tpm.business.audit.execute.information.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.execute.information.local.entity.AuditExecuteInformationFile;
import com.biz.crm.tpm.business.audit.execute.information.local.mapper.AuditExecuteInformationFileMapper;
import java.util.List;

import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationFileDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationFileVo;
import org.springframework.stereotype.Component;

/**
 * 执行资料表(repository)
 *
 * @author makejava
 * @date 2022-11-16 16:42:27
 */
@Component
public class AuditExecuteInformationFileRepository extends ServiceImpl<AuditExecuteInformationFileMapper, AuditExecuteInformationFile> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditExecuteInformationFileVo> findByConditions(Page<AuditExecuteInformationFileVo> page, AuditExecuteInformationFileDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditExecuteInformationFile findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditExecuteInformationFile> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditExecuteInformationFile::getId, ids).list();
    }


    /**
     * 根据关联资料主表ID删除
     * @param auditExecuteId 关联资料主表ID
     */
    public void removeByAuditExecuteId(String auditExecuteId) {
        this.lambdaUpdate().eq(AuditExecuteInformationFile::getAuditExecuteId,auditExecuteId).remove();
    }

    /**
     * 根据执行资料主表关联ID查询
     * @param auditExecuteId 关联资料主表ID
     * @return 执行资料文件列表
     */
    public List<AuditExecuteInformationFile> findDetailByAuditExecuteId(String auditExecuteId) {
        return this.lambdaQuery().eq(AuditExecuteInformationFile::getAuditExecuteId, auditExecuteId).list();
    }
}
