package com.biz.crm.tpm.business.audit.execute.information.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.execute.information.local.entity.AuditExecuteInformationImage;
import com.biz.crm.tpm.business.audit.execute.information.local.mapper.AuditExecuteInformationImageMapper;
import java.util.List;

import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationImageDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationImageVo;
import org.springframework.stereotype.Component;

/**
 * 执行资料表(repository)
 *
 * @author makejava
 * @date 2022-11-16 16:43:17
 */
@Component
public class AuditExecuteInformationImageRepository extends ServiceImpl<AuditExecuteInformationImageMapper, AuditExecuteInformationImage> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditExecuteInformationImageVo> findByConditions(Page<AuditExecuteInformationImageVo> page, AuditExecuteInformationImageDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditExecuteInformationImage findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditExecuteInformationImage> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditExecuteInformationImage::getId, ids).list();
    }


    /**
     * 根据关联资料主表ID删除
     * @param auditExecuteId 关联资料主表ID
     */
    public void removeByAuditExecuteId(String auditExecuteId) {
        this.lambdaUpdate().eq(AuditExecuteInformationImage::getAuditExecuteId,auditExecuteId).remove();
    }

    /**
     * 根据执行资料主表关联ID查询
     * @param auditExecuteId 关联资料主表ID
     * @return 执行资料图片列表
     */
    public List<AuditExecuteInformationImage> findDetailByAuditExecuteId(String auditExecuteId) {
        return this.lambdaQuery().eq(AuditExecuteInformationImage::getAuditExecuteId, auditExecuteId).list();
    }
}
