package com.biz.crm.tpm.business.audit.execute.information.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.execute.information.local.entity.AuditExecuteInformation;
import com.biz.crm.tpm.business.audit.execute.information.local.mapper.AuditExecuteInformationMapper;
import java.util.List;

import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationVo;
import org.springframework.stereotype.Component;

/**
 * 执行资料表(repository)
 *
 * @author makejava
 * @date 2022-11-16 16:39:45
 */
@Component
public class AuditExecuteInformationRepository extends ServiceImpl<AuditExecuteInformationMapper, AuditExecuteInformation> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditExecuteInformationVo> findByConditions(Page<AuditExecuteInformationVo> page, AuditExecuteInformationDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditExecuteInformation findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditExecuteInformation> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditExecuteInformation::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditExecuteInformation::getId, ids)
                .set(AuditExecuteInformation::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditExecuteInformation::getId, ids)
                .set(AuditExecuteInformation::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }
}
