package com.biz.crm.tpm.business.audit.execute.information.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.execute.information.local.entity.AuditExecuteInformationFile;
import com.biz.crm.tpm.business.audit.execute.information.local.repository.AuditExecuteInformationFileRepository;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationFileDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationFileLogEventDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.AuditExecuteInformationFileEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.log.AuditExecuteInformationFileLogEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationFileVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationFileVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 执行资料表(AuditExecuteInformationFile)表服务实现类
 *
 * @author makejava
 * @date 2022-11-16 16:42:27
 */
@Slf4j
@Service("auditExecuteInformationFileService")
public class AuditExecuteInformationFileVoServiceImpl implements AuditExecuteInformationFileVoService {

    @Autowired(required = false)
    private AuditExecuteInformationFileRepository auditExecuteInformationFileRepository;

    @Autowired(required = false)
    private List<AuditExecuteInformationFileEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<AuditExecuteInformationFileVo> findByConditions(Pageable pageable, AuditExecuteInformationFileDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditExecuteInformationFileDto());
        Page<AuditExecuteInformationFileVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditExecuteInformationFileRepository.findByConditions(page, dto);
    }

    @Override
    public AuditExecuteInformationFileVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditExecuteInformationFile auditExecuteInformationFile = this.auditExecuteInformationFileRepository.findById(id);
        if (auditExecuteInformationFile == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditExecuteInformationFile, AuditExecuteInformationFileVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    @Transactional
    public AuditExecuteInformationFileVo create(AuditExecuteInformationFileVo auditExecuteInformationFileVo) {
        this.createValidation(auditExecuteInformationFileVo);
        auditExecuteInformationFileVo.setTenantCode(TenantUtils.getTenantCode());


        AuditExecuteInformationFile auditExecuteInformationFile = nebulaToolkitService.copyObjectByWhiteList(auditExecuteInformationFileVo, AuditExecuteInformationFile.class, HashSet.class, ArrayList.class);
        this.auditExecuteInformationFileRepository.saveOrUpdate(auditExecuteInformationFile);

        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditExecuteInformationFileEventListener auditExecuteInformationFileEventListener : eventListeners) {
                auditExecuteInformationFileEventListener.onCreate(auditExecuteInformationFileVo);
            }
        }

        // 发送通知
        AuditExecuteInformationFileLogEventDto logEventDto = new AuditExecuteInformationFileLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditExecuteInformationFileVo);
        SerializableBiConsumer<AuditExecuteInformationFileLogEventListener, AuditExecuteInformationFileLogEventDto> onCreate =
                AuditExecuteInformationFileLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditExecuteInformationFileLogEventListener.class, onCreate);
        return auditExecuteInformationFileVo;
    }

    @Override
    @Transactional
    public AuditExecuteInformationFileVo update(AuditExecuteInformationFileVo auditExecuteInformationFileVo) {
        this.updateValidation(auditExecuteInformationFileVo);
        String currentId = auditExecuteInformationFileVo.getId();
        AuditExecuteInformationFile current = auditExecuteInformationFileRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditExecuteInformationFileVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, AuditExecuteInformationFileVo.class, HashSet.class, ArrayList.class);


        this.auditExecuteInformationFileRepository.saveOrUpdate(current);
        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditExecuteInformationFileEventListener auditExecuteInformationFileEventListener : eventListeners) {
                auditExecuteInformationFileEventListener.onUpdate(oldVo,auditExecuteInformationFileVo);
            }
        }

        // 发送修改通知
        AuditExecuteInformationFileLogEventDto logEventDto = new AuditExecuteInformationFileLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditExecuteInformationFileVo);
        SerializableBiConsumer<AuditExecuteInformationFileLogEventListener, AuditExecuteInformationFileLogEventDto> onUpdate =
                AuditExecuteInformationFileLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditExecuteInformationFileLogEventListener.class, onUpdate);
        return auditExecuteInformationFileVo;
    }


    /**
     * 根据关联资料主表ID删除
     * @param auditExecuteId 关联资料主表ID
     */
    @Override
    public void removeByAuditExecuteId(String auditExecuteId) {
        Validate.notNull(auditExecuteId,"关联执行资料主键不能为空");
        this.auditExecuteInformationFileRepository.removeByAuditExecuteId(auditExecuteId);
    }

    /**
     * 根据执行资料主表关联ID查询
     * @param auditExecuteId 关联资料主表ID
     * @return 执行资料文件列表
     */
    @Override
    public List<AuditExecuteInformationFileVo> findDetailByAuditExecuteId(String auditExecuteId) {
        if(StringUtils.isEmpty(auditExecuteId)){
            return Lists.newArrayList();
        }
        List<AuditExecuteInformationFile> auditExecuteInformationFiles = this.auditExecuteInformationFileRepository.findDetailByAuditExecuteId(auditExecuteId);

        if (CollectionUtils.isEmpty(auditExecuteInformationFiles)){
            return Lists.newArrayList();
        }
        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(auditExecuteInformationFiles
                ,AuditExecuteInformationFile.class,AuditExecuteInformationFileVo.class,HashSet.class,ArrayList.class));
    }

    private void createValidation(AuditExecuteInformationFileVo auditExecuteInformationFileVo) {
        this.validation(auditExecuteInformationFileVo);
    }

    private void updateValidation(AuditExecuteInformationFileVo auditExecuteInformationFileVo) {
        this.validation(auditExecuteInformationFileVo);
    }

    private void validation(AuditExecuteInformationFileVo auditExecuteInformationFileVo) {
        Validate.notNull(auditExecuteInformationFileVo.getAuditExecuteId(),"关联执行资料主表不存在");
    }
}
