package com.biz.crm.tpm.business.audit.execute.information.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.execute.information.local.entity.AuditExecuteInformationImage;
import com.biz.crm.tpm.business.audit.execute.information.local.repository.AuditExecuteInformationImageRepository;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationImageDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationImageLogEventDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.AuditExecuteInformationImageEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.log.AuditExecuteInformationImageLogEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationImageVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationImageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 执行资料表(AuditExecuteInformationImage)表服务实现类
 *
 * @author makejava
 * @date 2022-11-16 16:43:17
 */
@Slf4j
@Service("auditExecuteInformationImageService")
public class AuditExecuteInformationImageVoServiceImpl implements AuditExecuteInformationImageVoService {

    @Autowired(required = false)
    private AuditExecuteInformationImageRepository auditExecuteInformationImageRepository;

    @Autowired(required = false)
    private List<AuditExecuteInformationImageEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<AuditExecuteInformationImageVo> findByConditions(Pageable pageable, AuditExecuteInformationImageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditExecuteInformationImageDto());
        Page<AuditExecuteInformationImageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditExecuteInformationImageRepository.findByConditions(page, dto);
    }

    @Override
    public AuditExecuteInformationImageVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditExecuteInformationImage auditExecuteInformationImage = this.auditExecuteInformationImageRepository.findById(id);
        if (auditExecuteInformationImage == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditExecuteInformationImage, AuditExecuteInformationImageVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    @Transactional
    public AuditExecuteInformationImageVo create(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        this.createValidation(auditExecuteInformationImageVo);
        auditExecuteInformationImageVo.setTenantCode(TenantUtils.getTenantCode());


        AuditExecuteInformationImage auditExecuteInformationImage = nebulaToolkitService.copyObjectByWhiteList(auditExecuteInformationImageVo, AuditExecuteInformationImage.class, HashSet.class, ArrayList.class);
        this.auditExecuteInformationImageRepository.saveOrUpdate(auditExecuteInformationImage);

        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditExecuteInformationImageEventListener auditExecuteInformationImageEventListener : eventListeners) {
                auditExecuteInformationImageEventListener.onCreate(auditExecuteInformationImageVo);
            }
        }

        // 发送通知
        AuditExecuteInformationImageLogEventDto logEventDto = new AuditExecuteInformationImageLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditExecuteInformationImageVo);
        SerializableBiConsumer<AuditExecuteInformationImageLogEventListener, AuditExecuteInformationImageLogEventDto> onCreate =
                AuditExecuteInformationImageLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditExecuteInformationImageLogEventListener.class, onCreate);
        return auditExecuteInformationImageVo;
    }

    @Override
    @Transactional
    public AuditExecuteInformationImageVo update(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        this.updateValidation(auditExecuteInformationImageVo);
        String currentId = auditExecuteInformationImageVo.getId();
        AuditExecuteInformationImage current = auditExecuteInformationImageRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditExecuteInformationImageVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, AuditExecuteInformationImageVo.class, HashSet.class, ArrayList.class);


        this.auditExecuteInformationImageRepository.saveOrUpdate(current);
        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditExecuteInformationImageEventListener auditExecuteInformationImageEventListener : eventListeners) {
                auditExecuteInformationImageEventListener.onUpdate(oldVo,auditExecuteInformationImageVo);
            }
        }

        // 发送修改通知
        AuditExecuteInformationImageLogEventDto logEventDto = new AuditExecuteInformationImageLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditExecuteInformationImageVo);
        SerializableBiConsumer<AuditExecuteInformationImageLogEventListener, AuditExecuteInformationImageLogEventDto> onUpdate =
                AuditExecuteInformationImageLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditExecuteInformationImageLogEventListener.class, onUpdate);
        return auditExecuteInformationImageVo;
    }


    /**
     * 根据关联资料主表ID删除
     * @param auditExecuteId 关联资料主表ID
     */
    @Override
    public void removeByAuditExecuteId(String auditExecuteId) {
        Validate.notNull(auditExecuteId,"执行资料关联主键ID不能为空");
        this.auditExecuteInformationImageRepository.removeByAuditExecuteId(auditExecuteId);
    }

    /**
     * 根据执行资料主表关联ID查询
     * @param auditExecuteId 关联资料主表ID
     * @return 执行资料图片列表
     */
    @Override
    public List<AuditExecuteInformationImageVo> findDetailByAuditExecuteId(String auditExecuteId) {
        if (StringUtils.isEmpty(auditExecuteId)){
            return Lists.newArrayList();
        }
        List<AuditExecuteInformationImage> auditExecuteInformationImages = this.auditExecuteInformationImageRepository.findDetailByAuditExecuteId(auditExecuteId);

        if (CollectionUtils.isEmpty(auditExecuteInformationImages)){
            return Lists.newArrayList();
        }
        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(auditExecuteInformationImages
                ,AuditExecuteInformationImage.class,AuditExecuteInformationImageVo.class,HashSet.class,ArrayList.class));
    }

    private void createValidation(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        this.validation(auditExecuteInformationImageVo);
    }

    private void updateValidation(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        Validate.notEmpty(auditExecuteInformationImageVo.getId(),"修改时主键ID不能为空");
        this.validation(auditExecuteInformationImageVo);
    }

    private void validation(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        Validate.notNull(auditExecuteInformationImageVo.getAuditExecuteId(),"关联核销资料主表ID不能为空!");
    }
}
