package com.biz.crm.tpm.business.audit.execute.information.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.execute.information.local.entity.AuditExecuteInformation;
import com.biz.crm.tpm.business.audit.execute.information.local.repository.AuditExecuteInformationRepository;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationLogEventDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.AuditExecuteInformationEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.log.AuditExecuteInformationLogEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationFileVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationImageVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationFileVo;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationImageVo;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 执行资料表(AuditExecuteInformation)表服务实现类
 *
 * @author makejava
 * @date 2022-11-16 16:39:47
 */
@Slf4j
@Service("auditExecuteInformationService")
public class AuditExecuteInformationVoServiceImpl implements AuditExecuteInformationVoService {

    @Autowired(required = false)
    private AuditExecuteInformationRepository auditExecuteInformationRepository;

    @Autowired(required = false)
    private List<AuditExecuteInformationEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    /**
     * 核销资料文件service
     */
    @Resource
    private AuditExecuteInformationFileVoService auditExecuteInformationFileVoService;

    /**
     * 核销资料图片service
     */
    @Resource
    private AuditExecuteInformationImageVoService auditExecuteInformationImageVoService;

    @Override
    public Page<AuditExecuteInformationVo> findByConditions(Pageable pageable, AuditExecuteInformationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditExecuteInformationDto());
        Page<AuditExecuteInformationVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditExecuteInformationRepository.findByConditions(page, dto);
    }

    @Override
    public AuditExecuteInformationVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditExecuteInformation auditExecuteInformation = this.auditExecuteInformationRepository.findById(id);
        if (auditExecuteInformation == null) {
            return null;
        }
        AuditExecuteInformationVo executeInformationVo = nebulaToolkitService.copyObjectByWhiteList(auditExecuteInformation, AuditExecuteInformationVo.class, HashSet.class, ArrayList.class);
        executeInformationVo.setAuditExecuteInformationFiles(this.auditExecuteInformationFileVoService.findDetailByAuditExecuteId(executeInformationVo.getId()));
        executeInformationVo.setAuditExecuteInformationImages(this.auditExecuteInformationImageVoService.findDetailByAuditExecuteId(executeInformationVo.getId()));
        return   executeInformationVo;
    }

    @Override
    public List<AuditExecuteInformationFileVo> findFilesDetailById(String id) {
        return this.auditExecuteInformationFileVoService.findDetailByAuditExecuteId(id);
    }

    @Override
    public List<AuditExecuteInformationImageVo> findImagesDetailById(String id) {
        return this.auditExecuteInformationImageVoService.findDetailByAuditExecuteId(id);
    }

    @Override
    @Transactional
    public AuditExecuteInformationVo create(AuditExecuteInformationVo auditExecuteInformationVo) {
        this.createValidation(auditExecuteInformationVo);
        auditExecuteInformationVo.setTenantCode(TenantUtils.getTenantCode());
        auditExecuteInformationVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditExecuteInformationVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());

        AuditExecuteInformation auditExecuteInformation = nebulaToolkitService.copyObjectByWhiteList(auditExecuteInformationVo, AuditExecuteInformation.class, HashSet.class, ArrayList.class);
        this.auditExecuteInformationRepository.saveOrUpdate(auditExecuteInformation);
        auditExecuteInformationVo.setId(auditExecuteInformation.getId());

        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditExecuteInformationEventListener auditExecuteInformationEventListener : eventListeners) {
                auditExecuteInformationEventListener.onCreate(auditExecuteInformationVo);
            }
        }

        //执行资料文件列表
        if (CollectionUtils.isNotEmpty(auditExecuteInformationVo.getAuditExecuteInformationFiles())){
            auditExecuteInformationVo.getAuditExecuteInformationFiles().forEach(fileVo->{
                fileVo.setAuditExecuteId(auditExecuteInformation.getId());
                this.auditExecuteInformationFileVoService.create(fileVo);
            });
        }

        //执行资料图片列表
        if (CollectionUtils.isNotEmpty(auditExecuteInformationVo.getAuditExecuteInformationImages())){
            auditExecuteInformationVo.getAuditExecuteInformationImages().forEach(imageVo->{
                imageVo.setAuditExecuteId(auditExecuteInformation.getId());
                this.auditExecuteInformationImageVoService.create(imageVo);
            });
        }


        // 发送通知
        AuditExecuteInformationLogEventDto logEventDto = new AuditExecuteInformationLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditExecuteInformationVo);
        SerializableBiConsumer<AuditExecuteInformationLogEventListener, AuditExecuteInformationLogEventDto> onCreate =
                AuditExecuteInformationLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditExecuteInformationLogEventListener.class, onCreate);
        return auditExecuteInformationVo;
    }

    @Override
    @Transactional
    public AuditExecuteInformationVo update(AuditExecuteInformationVo auditExecuteInformationVo) {
        this.updateValidation(auditExecuteInformationVo);
        String currentId = auditExecuteInformationVo.getId();
        AuditExecuteInformation current = auditExecuteInformationRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditExecuteInformationVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, AuditExecuteInformationVo.class, HashSet.class, ArrayList.class);


        this.auditExecuteInformationRepository.saveOrUpdate(current);
        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditExecuteInformationEventListener auditExecuteInformationEventListener : eventListeners) {
                auditExecuteInformationEventListener.onUpdate(oldVo,auditExecuteInformationVo);
            }
        }

        //执行资料文件列表 更新
        this.auditExecuteInformationFileVoService.removeByAuditExecuteId(auditExecuteInformationVo.getId());
        if (CollectionUtils.isNotEmpty(auditExecuteInformationVo.getAuditExecuteInformationFiles())){
            auditExecuteInformationVo.getAuditExecuteInformationFiles().forEach(fileVo->{
                fileVo.setAuditExecuteId(auditExecuteInformationVo.getId());
                this.auditExecuteInformationFileVoService.create(fileVo);
            });
        }

        //执行资料图片列表 更新
        this.auditExecuteInformationImageVoService.removeByAuditExecuteId(auditExecuteInformationVo.getId());
        if (CollectionUtils.isNotEmpty(auditExecuteInformationVo.getAuditExecuteInformationImages())){
            auditExecuteInformationVo.getAuditExecuteInformationImages().forEach(imageVo->{
                imageVo.setAuditExecuteId(auditExecuteInformationVo.getId());
                this.auditExecuteInformationImageVoService.create(imageVo);
            });
        }

        // 发送修改通知
        AuditExecuteInformationLogEventDto logEventDto = new AuditExecuteInformationLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditExecuteInformationVo);
        SerializableBiConsumer<AuditExecuteInformationLogEventListener, AuditExecuteInformationLogEventDto> onUpdate =
                AuditExecuteInformationLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditExecuteInformationLogEventListener.class, onUpdate);
        return auditExecuteInformationVo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditExecuteInformationRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditExecuteInformationRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditExecuteInformationRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(AuditExecuteInformationVo auditExecuteInformationVo) {
        // TODO 具体实现
        this.validation(auditExecuteInformationVo);
    }

    private void updateValidation(AuditExecuteInformationVo auditExecuteInformationVo) {
        // TODO 具体实现
        this.validation(auditExecuteInformationVo);
    }

    private void validation(AuditExecuteInformationVo auditExecuteInformationVo) {
        // TODO 具体实现
    }
}
