/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.execute.information.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.execute.information.local.entity.AuditExecuteInformationImage;
import com.biz.crm.tpm.business.audit.execute.information.local.repository.AuditExecuteInformationImageRepository;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationImageDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationImageLogEventDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.AuditExecuteInformationImageEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.log.AuditExecuteInformationImageLogEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationImageVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationImageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="auditExecuteInformationImageService")
public class AuditExecuteInformationImageVoServiceImpl
implements AuditExecuteInformationImageVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditExecuteInformationImageVoServiceImpl.class);
    @Autowired(required=false)
    private AuditExecuteInformationImageRepository auditExecuteInformationImageRepository;
    @Autowired(required=false)
    private List<AuditExecuteInformationImageEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<AuditExecuteInformationImageVo> findByConditions(Pageable pageable, AuditExecuteInformationImageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditExecuteInformationImageDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditExecuteInformationImageRepository.findByConditions((Page<AuditExecuteInformationImageVo>)page, dto);
    }

    public AuditExecuteInformationImageVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditExecuteInformationImage auditExecuteInformationImage = this.auditExecuteInformationImageRepository.findById(id);
        if (auditExecuteInformationImage == null) {
            return null;
        }
        return (AuditExecuteInformationImageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditExecuteInformationImage, AuditExecuteInformationImageVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public AuditExecuteInformationImageVo create(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        this.createValidation(auditExecuteInformationImageVo);
        auditExecuteInformationImageVo.setTenantCode(TenantUtils.getTenantCode());
        AuditExecuteInformationImage auditExecuteInformationImage = (AuditExecuteInformationImage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditExecuteInformationImageVo, AuditExecuteInformationImage.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditExecuteInformationImageRepository.saveOrUpdate((Object)auditExecuteInformationImage);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditExecuteInformationImageEventListener auditExecuteInformationImageEventListener : this.eventListeners) {
                auditExecuteInformationImageEventListener.onCreate(auditExecuteInformationImageVo);
            }
        }
        AuditExecuteInformationImageLogEventDto logEventDto = new AuditExecuteInformationImageLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditExecuteInformationImageVo);
        SerializableBiConsumer & Serializable onCreate = AuditExecuteInformationImageLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditExecuteInformationImageLogEventListener.class, (SerializableBiConsumer)onCreate);
        return auditExecuteInformationImageVo;
    }

    @Transactional
    public AuditExecuteInformationImageVo update(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        this.updateValidation(auditExecuteInformationImageVo);
        String currentId = auditExecuteInformationImageVo.getId();
        AuditExecuteInformationImage current = this.auditExecuteInformationImageRepository.findById(currentId);
        current = (AuditExecuteInformationImage)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        AuditExecuteInformationImageVo oldVo = (AuditExecuteInformationImageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, AuditExecuteInformationImageVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditExecuteInformationImageRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditExecuteInformationImageEventListener auditExecuteInformationImageEventListener : this.eventListeners) {
                auditExecuteInformationImageEventListener.onUpdate(oldVo, auditExecuteInformationImageVo);
            }
        }
        AuditExecuteInformationImageLogEventDto logEventDto = new AuditExecuteInformationImageLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditExecuteInformationImageVo);
        SerializableBiConsumer & Serializable onUpdate = AuditExecuteInformationImageLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditExecuteInformationImageLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return auditExecuteInformationImageVo;
    }

    public void removeByAuditExecuteId(String auditExecuteId) {
        Validate.notNull((Object)auditExecuteId, (String)"\u6267\u884c\u8d44\u6599\u5173\u8054\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditExecuteInformationImageRepository.removeByAuditExecuteId(auditExecuteId);
    }

    public List<AuditExecuteInformationImageVo> findDetailByAuditExecuteId(String auditExecuteId) {
        if (StringUtils.isEmpty((CharSequence)auditExecuteId)) {
            return Lists.newArrayList();
        }
        List<AuditExecuteInformationImage> auditExecuteInformationImages = this.auditExecuteInformationImageRepository.findDetailByAuditExecuteId(auditExecuteId);
        if (CollectionUtils.isEmpty(auditExecuteInformationImages)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(auditExecuteInformationImages, AuditExecuteInformationImage.class, AuditExecuteInformationImageVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    private void createValidation(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        this.validation(auditExecuteInformationImageVo);
    }

    private void updateValidation(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        Validate.notEmpty((CharSequence)auditExecuteInformationImageVo.getId(), (String)"\u4fee\u6539\u65f6\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validation(auditExecuteInformationImageVo);
    }

    private void validation(AuditExecuteInformationImageVo auditExecuteInformationImageVo) {
        Validate.notNull((Object)auditExecuteInformationImageVo.getAuditExecuteId(), (String)"\u5173\u8054\u6838\u9500\u8d44\u6599\u4e3b\u8868ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
    }
}

