/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.execute.information.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.execute.information.local.entity.AuditExecuteInformation;
import com.biz.crm.tpm.business.audit.execute.information.local.repository.AuditExecuteInformationRepository;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationLogEventDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.AuditExecuteInformationEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.event.log.AuditExecuteInformationLogEventListener;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationFileVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationImageVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.service.AuditExecuteInformationVoService;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationFileVo;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationImageVo;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="auditExecuteInformationService")
public class AuditExecuteInformationVoServiceImpl
implements AuditExecuteInformationVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditExecuteInformationVoServiceImpl.class);
    @Autowired(required=false)
    private AuditExecuteInformationRepository auditExecuteInformationRepository;
    @Autowired(required=false)
    private List<AuditExecuteInformationEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Resource
    private AuditExecuteInformationFileVoService auditExecuteInformationFileVoService;
    @Resource
    private AuditExecuteInformationImageVoService auditExecuteInformationImageVoService;

    public Page<AuditExecuteInformationVo> findByConditions(Pageable pageable, AuditExecuteInformationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditExecuteInformationDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditExecuteInformationRepository.findByConditions((Page<AuditExecuteInformationVo>)page, dto);
    }

    public AuditExecuteInformationVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditExecuteInformation auditExecuteInformation = this.auditExecuteInformationRepository.findById(id);
        if (auditExecuteInformation == null) {
            return null;
        }
        AuditExecuteInformationVo executeInformationVo = (AuditExecuteInformationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditExecuteInformation, AuditExecuteInformationVo.class, HashSet.class, ArrayList.class, new String[0]);
        executeInformationVo.setAuditExecuteInformationFiles(this.auditExecuteInformationFileVoService.findDetailByAuditExecuteId(executeInformationVo.getId()));
        executeInformationVo.setAuditExecuteInformationImages(this.auditExecuteInformationImageVoService.findDetailByAuditExecuteId(executeInformationVo.getId()));
        return executeInformationVo;
    }

    public List<AuditExecuteInformationFileVo> findFilesDetailById(String id) {
        return this.auditExecuteInformationFileVoService.findDetailByAuditExecuteId(id);
    }

    public List<AuditExecuteInformationImageVo> findImagesDetailById(String id) {
        return this.auditExecuteInformationImageVoService.findDetailByAuditExecuteId(id);
    }

    @Transactional
    public AuditExecuteInformationVo create(AuditExecuteInformationVo auditExecuteInformationVo) {
        this.createValidation(auditExecuteInformationVo);
        auditExecuteInformationVo.setTenantCode(TenantUtils.getTenantCode());
        auditExecuteInformationVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditExecuteInformationVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        AuditExecuteInformation auditExecuteInformation = (AuditExecuteInformation)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditExecuteInformationVo, AuditExecuteInformation.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditExecuteInformationRepository.saveOrUpdate((Object)auditExecuteInformation);
        auditExecuteInformationVo.setId(auditExecuteInformation.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditExecuteInformationEventListener auditExecuteInformationEventListener : this.eventListeners) {
                auditExecuteInformationEventListener.onCreate(auditExecuteInformationVo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)auditExecuteInformationVo.getAuditExecuteInformationFiles())) {
            auditExecuteInformationVo.getAuditExecuteInformationFiles().forEach(fileVo -> {
                fileVo.setAuditExecuteId(auditExecuteInformation.getId());
                this.auditExecuteInformationFileVoService.create(fileVo);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)auditExecuteInformationVo.getAuditExecuteInformationImages())) {
            auditExecuteInformationVo.getAuditExecuteInformationImages().forEach(imageVo -> {
                imageVo.setAuditExecuteId(auditExecuteInformation.getId());
                this.auditExecuteInformationImageVoService.create(imageVo);
            });
        }
        AuditExecuteInformationLogEventDto logEventDto = new AuditExecuteInformationLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditExecuteInformationVo);
        SerializableBiConsumer & Serializable onCreate = AuditExecuteInformationLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditExecuteInformationLogEventListener.class, (SerializableBiConsumer)onCreate);
        return auditExecuteInformationVo;
    }

    @Transactional
    public AuditExecuteInformationVo update(AuditExecuteInformationVo auditExecuteInformationVo) {
        this.updateValidation(auditExecuteInformationVo);
        String currentId = auditExecuteInformationVo.getId();
        AuditExecuteInformation current = this.auditExecuteInformationRepository.findById(currentId);
        current = (AuditExecuteInformation)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        AuditExecuteInformationVo oldVo = (AuditExecuteInformationVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, AuditExecuteInformationVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditExecuteInformationRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditExecuteInformationEventListener auditExecuteInformationEventListener : this.eventListeners) {
                auditExecuteInformationEventListener.onUpdate(oldVo, auditExecuteInformationVo);
            }
        }
        this.auditExecuteInformationFileVoService.removeByAuditExecuteId(auditExecuteInformationVo.getId());
        if (CollectionUtils.isNotEmpty((Collection)auditExecuteInformationVo.getAuditExecuteInformationFiles())) {
            auditExecuteInformationVo.getAuditExecuteInformationFiles().forEach(fileVo -> {
                fileVo.setAuditExecuteId(auditExecuteInformationVo.getId());
                this.auditExecuteInformationFileVoService.create(fileVo);
            });
        }
        this.auditExecuteInformationImageVoService.removeByAuditExecuteId(auditExecuteInformationVo.getId());
        if (CollectionUtils.isNotEmpty((Collection)auditExecuteInformationVo.getAuditExecuteInformationImages())) {
            auditExecuteInformationVo.getAuditExecuteInformationImages().forEach(imageVo -> {
                imageVo.setAuditExecuteId(auditExecuteInformationVo.getId());
                this.auditExecuteInformationImageVoService.create(imageVo);
            });
        }
        AuditExecuteInformationLogEventDto logEventDto = new AuditExecuteInformationLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditExecuteInformationVo);
        SerializableBiConsumer & Serializable onUpdate = AuditExecuteInformationLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditExecuteInformationLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return auditExecuteInformationVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditExecuteInformationRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditExecuteInformationRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditExecuteInformationRepository.updateDelFlagByIds(ids);
    }

    private void createValidation(AuditExecuteInformationVo auditExecuteInformationVo) {
        this.validation(auditExecuteInformationVo);
    }

    private void updateValidation(AuditExecuteInformationVo auditExecuteInformationVo) {
        this.validation(auditExecuteInformationVo);
    }

    private void validation(AuditExecuteInformationVo auditExecuteInformationVo) {
    }
}

