package com.biz.crm.tpm.business.audit.execute.information.sdk.dto.sfa;

import lombok.Data;

import java.math.BigDecimal;

/**
 * SFA结案资料推送接口
 *
 * @author wanghaojia
 * @date 2023/1/5 15:36
 */
@Data
public class SfaAuditExecuteInformationDto {

    /**
     * 结案明细编号
     */
    private String closureNo;
    /**
     * 活动细案编号
     */
    private String activityDetailsCode;
    /**
     * 客户编码
     */
    private String dealerCode;
    /**
     * 客户名称
     */
    private String dealerName;
    /**
     * 费用月份
     */
    private String expenseMonth;
    /**
     * 人员编码
     */
    private String userNo;
    /**
     * 人员名称
     */
    private String userName;
    /**
     * 人员类型
     */
    private String userType;
    /**
     * 人员身份证号
     */
    private String identityCardNumber;
    /**
     * 人员电话号码
     */
    private String userPhone;
    /**费用合计

     * 费用开始日期
     */
    private String expenseStartTime;
    /**
     * 费用结束日期
     */
    private String expenseEndTime;
    /**
     * 费用合计
     */
    private BigDecimal totalExpenses;
    /**
     * 申请费用
     */
    private BigDecimal applicationFee;
    /**
     * 经销商承担费用金额
     */
    private BigDecimal dealerBearFee;

    /**
     * 身份证照片
     */
    private String identityCardFileCode;
    /**
     * 拜访天数
     */
    private Integer visitActualDays;
    /**
     * 打卡合格天数
     */
    private Integer clockInLeastDays;
    /**
     * 考勤天数
     */
    private Integer clocInActualDays;
    /**
     * 排班天数
     */
    private Integer rosteringDays;
    /**
     * 公事报备天数
     */
    private Integer businessReportingDays;
    /**
     * 结案天数
     */
    private Integer closureDays;
    /**
     * 结案金额
     */
    private BigDecimal closureFee;
    /**
     * 销量达成%
     */
    private BigDecimal salesAchieved;
    /**
     * 考核销量结案金额
     */
    private BigDecimal closureAppraiseFee;
    /**
     * 形式说明
     */
    private String description;
    /**
     * 备注
     */
    private String remark;

    private SfaAuditExecuteInformationImageDto personnelExpensesClosureFileClassificationSynDto;
}
