package com.biz.crm.tpm.business.audit.execute.information.sdk.dto.sfa;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * SFA结案资料主体推送接口
 *
 * @author wanghaojia
 * @date 2023/1/5 15:36
 */
@Data
public class SfaAuditExecuteInformationMainDto {


    /**
     * 结案明细编号
     */
    private String closureNo;
    /**
     * 费用申请明细
     */
    private String expenseApplyDetail;
    /**
     * MDG客户编码
     */
    private String dealerCode;
    /**
     * MDG客户名称
     */
    private String dealerName;
    /**
     * 下级客户编码
     */
    @ApiModelProperty("下级客户编码")
    private String childCustomerErpCode;
    /**
     * 下级客户名称
     */
    @ApiModelProperty("客户名称")
    private String childCustomerName;
    /**
     * 费用月份
     */
    private String expenseMonth;
    /**
     * 门店编码
     */
    private String terminalCode;
    /**
     * 门店名称
     */
    private String terminalName;
    /**
     * 门店二级渠道编码
     */
    private String terminalSecondChannelCode;
    /**
     * 结案金额
     */
    private BigDecimal auditAmount;
    /**
     * 兑付金额
     */
    private BigDecimal paymentAmount;
    /**
     * 兑付方式
     */
    private String paymentType;
    /**
     * 优惠券订单号
     */
    private String discountCouponNo;

    private SfaAuditExecuteInformationImageDto personnelExpensesClosureFileClassificationSynDto;
}
