package com.biz.crm.tpm.business.audit.execute.information.sdk.event;

import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationVo;

import java.util.List;

/**
 * 执行资料表变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-16 16:41:53
 */
public interface AuditExecuteInformationEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(AuditExecuteInformationVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(AuditExecuteInformationVo oldVo, AuditExecuteInformationVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<AuditExecuteInformationVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<AuditExecuteInformationVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<AuditExecuteInformationVo> list);
}

