package com.biz.crm.tpm.business.audit.execute.information.sdk.event;

import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationFileVo;

import java.util.List;

/**
 * 执行资料表变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-16 16:42:52
 */
public interface AuditExecuteInformationFileEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(AuditExecuteInformationFileVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(AuditExecuteInformationFileVo oldVo, AuditExecuteInformationFileVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<AuditExecuteInformationFileVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<AuditExecuteInformationFileVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<AuditExecuteInformationFileVo> list);
}

