package com.biz.crm.tpm.business.audit.execute.information.sdk.event;

import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationImageVo;

import java.util.List;

/**
 * 执行资料表变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-16 16:43:39
 */
public interface AuditExecuteInformationImageEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(AuditExecuteInformationImageVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(AuditExecuteInformationImageVo oldVo, AuditExecuteInformationImageVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<AuditExecuteInformationImageVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<AuditExecuteInformationImageVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<AuditExecuteInformationImageVo> list);
}

