package com.biz.crm.tpm.business.audit.execute.information.sdk.event.log;

import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * 执行资料表变更事件通知接口
 *
 * @author makejava
 * @date 2022-11-16 16:41:54
 */
public interface AuditExecuteInformationLogEventListener extends NebulaEvent {


    /**
     * 创建日志事件
     */
    void onCreate(AuditExecuteInformationLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto  核销资料新旧VO
     */
    void onDelete(AuditExecuteInformationLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto 核销资料新旧VO
     */
    void onUpdate(AuditExecuteInformationLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto 核销资料新旧VO
     */
    void onEnable(AuditExecuteInformationLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto 核销资料新旧VO
     */
    void onDisable(AuditExecuteInformationLogEventDto eventDto);

}

