package com.biz.crm.tpm.business.audit.execute.information.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationFileDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationFileVo;
import org.springframework.data.domain.Pageable;

/**
 * 执行资料表(AuditExecuteInformationFile)表服务接口
 *
 * @author makejava
 * @date 2022-11-16 16:42:53
 */
public interface AuditExecuteInformationFileVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<AuditExecuteInformationFileVo> findByConditions(Pageable pageable, AuditExecuteInformationFileDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    AuditExecuteInformationFileVo findDetailById(String id);

    /**
     * 创建
     *
     * @param auditExecuteInformationFileVo
     * @return
     */
    AuditExecuteInformationFileVo create(AuditExecuteInformationFileVo auditExecuteInformationFileVo);

    /**
     * 更新
     *
     * @param auditExecuteInformationFileVo
     * @return
     */
    AuditExecuteInformationFileVo update(AuditExecuteInformationFileVo auditExecuteInformationFileVo);


    /**
     * 根据关联资料主表ID删除
     * @param auditExecuteId 关联资料主表ID
     */
    void removeByAuditExecuteId(String auditExecuteId);

    /**
     * 根据执行资料主表关联ID查询
     * @param auditExecuteId 关联资料主表ID
     * @return 执行资料文件列表
     */
    List<AuditExecuteInformationFileVo> findDetailByAuditExecuteId(String auditExecuteId);
}
