package com.biz.crm.tpm.business.audit.execute.information.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationImageDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationImageVo;
import org.springframework.data.domain.Pageable;

/**
 * 执行资料表(AuditExecuteInformationImage)表服务接口
 *
 * @author makejava
 * @date 2022-11-16 16:43:40
 */
public interface AuditExecuteInformationImageVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<AuditExecuteInformationImageVo> findByConditions(Pageable pageable, AuditExecuteInformationImageDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    AuditExecuteInformationImageVo findDetailById(String id);

    /**
     * 创建
     *
     * @param auditExecuteInformationImageVo
     * @return
     */
    AuditExecuteInformationImageVo create(AuditExecuteInformationImageVo auditExecuteInformationImageVo);

    /**
     * 更新
     *
     * @param auditExecuteInformationImageVo
     * @return
     */
    AuditExecuteInformationImageVo update(AuditExecuteInformationImageVo auditExecuteInformationImageVo);


    /**
     * 根据关联资料主表ID删除
     * @param auditExecuteId 关联资料主表ID
     */
    void removeByAuditExecuteId(String auditExecuteId);

    /**
     * 根据执行资料主表关联ID查询
     * @param auditExecuteId 关联资料主表ID
     * @return 执行资料图片列表
     */
    List<AuditExecuteInformationImageVo> findDetailByAuditExecuteId(String auditExecuteId);
}
