package com.biz.crm.tpm.business.audit.execute.information.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

import com.biz.crm.tpm.business.audit.execute.information.sdk.dto.AuditExecuteInformationDto;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationFileVo;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationImageVo;
import com.biz.crm.tpm.business.audit.execute.information.sdk.vo.AuditExecuteInformationVo;
import org.springframework.data.domain.Pageable;

/**
 * 执行资料表(AuditExecuteInformation)表服务接口
 *
 * @author makejava
 * @date 2022-11-16 16:41:53
 */
public interface AuditExecuteInformationVoService {

    /**
     * 分页条件查询
     *
     * @param pageable 分页参数
     * @param dto  执行资料表查询dto
     * @return 执行资料列表
     */
    Page<AuditExecuteInformationVo> findByConditions(Pageable pageable, AuditExecuteInformationDto dto);

    /**
     * 按id查询详情
     *
     * @param id 主键id
     * @return 执行资料表Vo
     */
    AuditExecuteInformationVo findDetailById(String id);

    /**
     * 创建
     *
     * @param auditExecuteInformationVo 执行资料表查询条件
     * @return 执行资料表Vo
     */
    AuditExecuteInformationVo create(AuditExecuteInformationVo auditExecuteInformationVo);

    /**
     * 更新
     *
     * @param auditExecuteInformationVo 执行资料表查询条件
     * @return 执行资料表Vo
     */
    AuditExecuteInformationVo update(AuditExecuteInformationVo auditExecuteInformationVo);

    /**
     * 按id集合启用
     *
     * @param ids 主键id
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids 主键id
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids 主键id
     */
    void updateDelFlagByIds(List<String> ids);

    /**
     * 根据id查询关联文件列表
     * @param id 主键id
     * @return  执行文件列表
     */
    List<AuditExecuteInformationFileVo> findFilesDetailById(String id);

    /**
     * 根据id查询关联文件列表
     * @param id 主键id
     * @return  执行文件列表
     */
    List<AuditExecuteInformationImageVo> findImagesDetailById(String id);
}
