package com.biz.crm.tpm.business.audit.execute.information.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 执行资料表vo
 *
 * @author makejava
 * @date 2022-11-16 16:41:54
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "执行资料表Vo")
public class AuditExecuteInformationVo extends TenantFlagOpVo {

    /**
     * 活动细案编码
     */
    @ApiModelProperty(name = "detailPlanCode",value = "活动细案编码")
    private String detailPlanCode;
    /**
     * 活动细案名称
     */
    @ApiModelProperty(name = "detailPlanName",value = "活动细案名称")
    private String detailPlanName;

    /**
     * 活动细案明细编码
     */
    @ApiModelProperty(name = "activityDetailItemCode",value = "活动细案明细编码")
    private String activityDetailItemCode;


    /**
     * 活动开始时间
     */
    @ApiModelProperty(name = "activityStartTime", value = "活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    @ApiModelProperty(name = "activityEndTime", value = "活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndTime;


    /**
     * 业态
     */
    @ApiModelProperty(name = "formats", value = "业态")
    private String formats;


    /**
     * 预算项目编码
     */
    @ApiModelProperty(name = "budgetItemCode", value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(name = "budgetItemName", value = "预算项目名称")
    private String budgetItemName;


    @ApiModelProperty(name = "activityTypeCode", value = "活动类型")
    private String activityTypeCode;


    @ApiModelProperty(name = "activityTypeName", value = "活动类型名称")
    private String activityTypeName;


    @ApiModelProperty(name = "orgCode", value = "组织编码")
    private String orgCode;


    @ApiModelProperty(name = "orgName", value = "组织名称")
    private String orgName;


    @ApiModelProperty(name = "customerGrade", value = "客户等级")
    private String customerGrade;


    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;


    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;


    @ApiModelProperty(name = "supplierCode", value = "供应商编码")
    private String supplierCode;


    @ApiModelProperty(name = "supplierName", value = "供应商名称")
    private String supplierName;

    /**
     * 门店编码
     */
    @ApiModelProperty(name = "terminalCode", value = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @ApiModelProperty(name = "terminalName", value = "门店名称")
    private String terminalName;


    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "productBrandCode", value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "productBrandName", value = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(name = "productCategoryCode", value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(name = "productCategoryName", notes = "品类名称")
    private String productCategoryName;



    @ApiModelProperty(name = "productCode", value = "产品编码")
    private String productCode;


    @ApiModelProperty(name = "productName", value = "产品名称")
    private String productName;

    /**
     * 总申请金额
     */
    @ApiModelProperty(name = "applyAmount", value = "申请金额")
    private BigDecimal applyAmount;


    /**
     * 调整金额
     */
    @ApiModelProperty(name = "adjust_amount", value = "调整金额")
    private BigDecimal adjustAmount;

    /**
     * 实际总申请金额
     */
    @ApiModelProperty(name = "actualApplyAmount", value = "实际总申请金额")
    private BigDecimal actualApplyAmount;

    /**
     * 执行时间
     */
    @ApiModelProperty(name = "excuteDate", value = "执行时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    private Date excuteDate;

    @ApiModelProperty(name = "auditExecuteInformationFiles", value = "执行资料文件列表")
    private List<AuditExecuteInformationFileVo> auditExecuteInformationFiles;

    @ApiModelProperty(name = "auditExecuteInformationImages", value = "执行资料图片列表")
    private List<AuditExecuteInformationImageVo> auditExecuteInformationImages;
}

