package com.biz.crm.tpm.business.audit.fee.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.feign.feign.internal.AuditFeeCheckFeignImpl;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/6/15
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = AuditFeeCheckFeignImpl.class)
public interface AuditFeeCheckFeign {


    @ApiOperation("分页查询")
    @GetMapping("/v1/auditFeeCheck/auditFeeCheck/findByConditionsForEct")
    Result<Page<AuditFeeCheckVo>> findByConditionsForEct(@PageableDefault(50)Pageable pageable,@SpringQueryMap AuditFeeCheckSelectDto dto);
}
