package com.biz.crm.tpm.business.audit.fee.local.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanCloseMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.prediction.AuditFeePredictionVoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @Description 活动细案关闭MQ
 * @Author zhouYang
 * @Date 2023/10/11
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityDetailPlanCloseMqTagConstant.PROCESS_CLOSE_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityDetailPlanCloseMqTagConstant.CLOSE_AUDIT_FEE_PREDICTION,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityDetailPlanCloseMqTagConstant.CLOSE_AUDIT_FEE_PREDICTION + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityDetailPlanClosePushPredictionConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired
    private AuditFeePredictionVoService voService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("活动细案关闭推送费用预测管理 order mq message received  : {}", message);
        if (Objects.isNull(message) || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }
        List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
        List<ActivityDetailPlanItemVo> voList = activityDetailPlanItemSdkService.listByItemCodeList(businessNoList);
        log.info("垂直活动细案信息：{}", JSONObject.toJSONString(voList));
        List<AuditFeePredictionDto> dtos = Lists.newArrayList();
        voList.forEach(e -> {
            AuditFeePredictionDto predictionDto = new AuditFeePredictionDto();
            predictionDto.setIsClose(e.getIsClose());
            predictionDto.setCloseDate(e.getCloseDate());
            predictionDto.setDetailPlanItemCode(e.getDetailPlanItemCode());
            dtos.add(predictionDto);
        });
        voService.updateCloseDate(dtos);
        return "消费成功.";
    }
}
