package com.biz.crm.tpm.business.audit.fee.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanListDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zy
 * @date 2023/09/24
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityDetailPlanConstant.TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityDetailPlanPassMqTagConstant.PASS_AUDIT_FEE_PREDICTION,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityDetailPlanPassMqTagConstant.PASS_AUDIT_FEE_PREDICTION + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityDetailPlanPassAuditFeePredictionConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private AuditFeePredictionService predictionService;
    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TerminalVoService terminalVoService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("活动细案审批通过推送费用预测管理 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            List<String> detailPlanCodeList = JSON.parseArray(message.getMsgBody(), String.class);

            List<ActivityDetailPlanDto> dtoList = activityDetailPlanSdkService.buildActivityDetailPlanParams(detailPlanCodeList);
            log.info("垂直活动细案信息：{}",dtoList);
            ActivityDetailPlanListDto dto = new ActivityDetailPlanListDto();
            dto.setList(dtoList);

            List<AuditFeePredictionDto> predictionDtoList = this.buildData(dto);
            if (CollectionUtils.isEmpty(predictionDtoList)) {
                return "消费成功.";
            }
            predictionService.createBatch(predictionDtoList);
        }catch (Exception e){
            log.error(ActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }


    private List<AuditFeePredictionDto> buildData(ActivityDetailPlanListDto listDto) {
        List<AuditFeePredictionDto> predictionDtoList = Lists.newArrayList();
        if (Objects.isNull(listDto)) {
            return predictionDtoList;
        }
        List<ActivityDetailPlanDto> activityDetailPlanDtoList = listDto.getList();
        if (CollectionUtils.isEmpty(activityDetailPlanDtoList)) {
            return predictionDtoList;
        }
        // 查询活动形式信息
        List<ActivityDetailPlanItemDto> itemList = Lists.newArrayList();
        activityDetailPlanDtoList.forEach(activityDetailPlanDto -> {
            itemList.addAll(activityDetailPlanDto.getItemList());
        });
        Map<String,ActivityDetailPlanDto> activityDetailPlanDtoMap = activityDetailPlanDtoList.stream().collect(Collectors.toMap(ActivityDetailPlanDto::getDetailPlanCode,Function.identity()));
        List<String> activityFormCodes = itemList.stream().map(ActivityDetailPlanItemBase::getActivityFormCode).collect(Collectors.toList());
        List<ActivityFormVo> activityFormVos = activityFormService.findByCodes(activityFormCodes);
        List<ActivityDetailPlanItemDto> itemListTwo= itemList.stream()
                .filter(a -> StringUtils.isEmpty(a.getWriteOffMethod()) || StringUtils.equals(a.getWriteOffMethod(), WriteOffMethodEnum.AFTER_THE_EVENT.getCode()))
                .collect(Collectors.toList());
        Map<String,ActivityFormVo> activityFormVoMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        // 门店信息
        List<String> terminalCodes = itemList.stream().map(ActivityDetailPlanItemBase::getTerminalCode).collect(Collectors.toList());
        List<TerminalVo> terminalVos = terminalVoService.findByTerminalCodes(terminalCodes);
        Map<String,TerminalVo> terminalVoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(terminalVos)) {
            terminalVoMap.putAll(terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode,Function.identity())));
        }
        itemListTwo.forEach(item ->{
            if (activityFormVoMap.containsKey(item.getActivityFormCode())) {
                ActivityFormVo activityFormVo = activityFormVoMap.get(item.getActivityFormCode());
                if (activityFormVo.getIsSupermarketDeductionItem()) {
                    AuditFeePredictionDto dto = this.nebulaToolkitService.copyObjectByWhiteList(item,AuditFeePredictionDto.class, HashSet.class, ArrayList.class);
                    dto.setId(null);
                    if (activityDetailPlanDtoMap.containsKey(item.getDetailPlanCode())) {
                        dto.setDetailPlanName(activityDetailPlanDtoMap.get(item.getDetailPlanCode()).getDetailPlanName());
                    }
                    if (terminalVoMap.containsKey(item.getTerminalCode())) {
                        dto.setProvinceCode(terminalVoMap.get(item.getTerminalCode()).getProvinceCode());
                        dto.setProvinceName(terminalVoMap.get(item.getTerminalCode()).getProvinceName());
                    }
                    dto.setCustomerCode(item.getCustomerErpCode());
                    dto.setApplyAmount(item.getFeeAmount());
                    dto.setSalesInstitutionCode(item.getSalesInstitutionErpCode());
                    dto.setSalesInstitutionName(item.getActivityOrgName());
                    dto.setActivityYearMonth(item.getActivityBeginDate());
                    dto.setDataSource(DataSourceEnum.ACTIVITY_DETAIL.getCode());
                    dto.setWholeAudit(YesOrNoEnum.NO.getCode());
                    dto.setRollbackBudgetTag(item.getRollbackBudgetTag());
                    dto.setIsClose(YesOrNoEnum.NO.getCode());
                    dto.setRetailerChannel(item.getRetailerChannel());
                    dto.setActivityFormDesc(item.getRemark());
                    predictionDtoList.add(dto);
                }
            }
        });
        return predictionDtoList;
    }

}
